
files_move <- function( path1 , path2 , file_sep ="__", pattern = NULL)
{

	#*** search for all relevant files
	files <- base::list.files( path1 , "\\."  )
	if ( ! base::is.null( pattern) ){
		files <- base::grep( pattern = pattern , x = files , value=TRUE)
	}
	#*** create file overview
	NF <- base::length(files)
	if (NF > 0 ){
		matr <- matrix( NA , nrow=NF , ncol=5)	
		for (ff in 1:NF){
			# ff <- 1
			file_ff <- files[ff]
			res_ff <- filename_split( file_name = file_ff , file_sep = file_sep )
			matr[ff,] <- base::unlist(res_ff)
		}	
		matr <- base::as.data.frame(matr)
		base::colnames(matr) <- names(res_ff)
		matr$main_id <- match( matr$main , unique( matr$main) )
		
		matr <- matr[ base::order( matr$main ) , ]
		matr$eq <- base::c(0,matr$main[ - NF ] != matr$main[-1])
		t1 <- base::table( matr$main_id )
		ind1 <- base::match( matr$main_id , base::names(t1))
		matr$freq <- t1[ind1]	
# Revalpr("matr")		
		for (ff in 2:NF){
			if ( matr[ff,"main"] == matr[ ff -1 , "main"] ){
				base::file.rename( from= base::file.path( path1 , matr[ff-1,"file_name"] ) ,
						to = base::file.path( path2 , matr[ff-1,"file_name"] ) )					
				cat("*** Move " , base::paste0(matr[ff-1,"file_name"]) , "\n" )
				utils::flush.console();
			}
	
		}
	}
}