\name{mipo}
%classes
\alias{mipo-class}

%functions
\alias{mipo}
\alias{is.mipo}

\alias{print,mipo-method}
\alias{summary,mipo-method}

\title{Multiply Imputed Pooled Analysis}

\usage{
is.mipo(x)
\S4method{print}{mipo}(x,\dots)
\S4method{summary}{mipo}(object,\dots)
}

\description{
  The \code{mipo} object is generated by the \code{\link{pool}} function from a \code{link{mira}} object.
  The \code{mipo} class of objects has methods for the following generic functions:
  \code{print}, \code{summary}.
}

\arguments{
    \item{x, object}{An object of class \code{mira} containing the \code{m} fit objects of a complete data analysis, 
        plus some additional information.}
    \item{\dots}{not used.}
}
\value{
  \item{call}{  The call that created the \code{mipo} object.}
  \item{call1}{ The call that created the \code{mira} object that was used in \code{call}.}
  \item{call2}{ The call that created the \code{mids} object that was used in \code{call1}.}
  \item{nmis}{  An array containing the number of missing observations per column.}
  \item{m}{Number of multiple imputations.}
  \item{qhat}{An \code{m} by \code{npar} matrix containing the complete data estimates for the \code{npar} parameters of the \code{m} complete data analyses.}
  \item{u}{An \code{m} by \code{npar} by \code{npar} array containing the variance-covariance matrices of the \code{m} complete data analyses.}
  \item{qbar}{The average of complete data estimates.}
  \item{ubar}{The average of the variance-covariance matrix of the complete data estimes.}
  \item{b}{The between imputation variance-covariance matrix.}
  \item{t}{The total variance-covariance matrix.}
  \item{r}{Relative increases in variance due to missing data.}
  \item{dfcom}{Degrees of freedom in the hypothetically complete data: the sample size minus the number of free parameters.}
  \item{df}{Degrees of freedom associated with the t-statistics.}
  \item{fmi}{Fraction of missing information.}
  \item{lambda}{Proportion of the variation attributable to the missing data: (b+b/m)/t.}
}

\references{
Van Buuren, S., Groothuis-Oudshoorn, K. (2010) 
MICE: Multivariate Imputation by Chained Equations in R. 
\emph{Journal of Statistical Software}, forthcoming.
\url{http://www.stefvanbuuren.nl/publications/MICE in R - Draft.pdf}
}

\seealso{\code{\link{pool}}, \code{\link{mids}}, \code{\link{mira}}}


\author{Stef van Buuren, Karin Groothuis-Oudshoorn, 2000}   

\keyword{classes}  
