\name{mids}
%classes
\alias{mids-class}

%functions
\alias{mids}
\alias{is.mids}

%methods
\alias{plot}
\alias{plot.mids}
\alias{print,mids-method}
\alias{summary,mids-method}
\alias{plot,mids-method}
\alias{plot,mids,ANY-method}

\title{Multiply Imputed Data Set}

\usage{
is.mids(x)
\S4method{print}{mids}(x,\dots)
\S4method{summary}{mids}(object,\dots)
\S4method{plot}{mids,ANY}(x, y, \dots)

plot.mids(x, y=NULL, theme=mice.theme(),
                        layout=c(2,3), type="l", col=1:10, lty=1,
                        ...)
}

\description{An object containing a multiply imputed data set. The
  \code{mids} object is generated by the \code{mice} and \code{mice.mids} functions. The
  \code{mids} class of objects has methods for the following generic
  functions: \code{print}, \code{summary}, \code{plot}.
}
\arguments{
  \item{x, object}{A object of class \code{mids}.}
  \item{y}{A character vector containing variable names, an integer vector of indices of imputed variables, a logical vector of 
 \code{length(dimnames(x$chainMean[,,1])[[1]])}, or a formula. The result of the evaluation will be plotted in the trace plot.}
  \item{theme}{List of settings with selected graphical parameters to control the \pkg{lattice} function \code{xyplot()}.}
  \item{layout}{Vector of two numbers controlling the number of panels in horizontal and vertical direction, respectively.}
  \item{type}{Plot type parameter.}
  \item{col}{Color parameter.}
  \item{lty}{Line type parameter.} 
  \item{\dots}{Currently not used.}
}
\value{
  \item{call}{  The call that created the object.}
  \item{data}{  A copy of the incomplete data set.}
  \item{m}{ The number of imputations.}
  \item{nmis}{  An array containing the number of missing observations per column.}
  \item{imp}{   A list of nvar components with the generated multiple imputations. 
    Each part of the list is a \code{nmis[j]} by \code{m} matrix of imputed values for 
    variable \code{j}.}
  \item{method}{A vector of strings of length(nvar) specifying the elementary 
    imputation method per column.}
  \item{predictorMatrix}{
    A square matrix of size \code{ncol(data)} containing code 0/1 data specifying 
    the predictor set.}
  \item{visitSequence}{
    The sequence in which columns are visited.}
  \item{post}{A vector of strings of length \code{ncol(data)} with commands for post-processing}
  \item{seed}{  The seed value of the solution.}
  \item{iteration}{
    Last Gibbs sampling iteration number.}
  \item{lastSeedValue}{
    The most recent seed value.}
  \item{chainMean}{
    A list of \code{m} components. Each component is a \code{length(visitSequence)}
    by \code{maxit} matrix containing the mean of the generated multiple 
    imputations. The array can be used for monitoring convergence.
    Note that observed data are not present in this mean.}
  \item{chainVar}{
    A list with similar structure of \code{chainMean}, containing the covariances 
    of the imputed values.}
  \item{pad}{   A list containing various settings of the padded imputation model, 
    i.e. the imputation model after creating dummy variables. Normally, 
    this array is only useful for error checking.}
}
\references{
Van Buuren, S., Groothuis-Oudshoorn, K. (2010) 
MICE: Multivariate Imputation by Chained Equations in R. 
\emph{Journal of Statistical Software}, forthcoming.
\url{http://www.stefvanbuuren.nl/publications/MICE in R - Draft.pdf}
}

\seealso{\code{\link{mice}}, \code{\link{mira}}, \code{\link{mipo}}}

\author{Stef van Buuren, Karin Groothuis-Oudshoorn, 2000}

\keyword{classes}
