#'Multiply imputed pooled analysis  (\code{mipo})
#'
#'The \code{mipo} object is generated by the \code{\link{pool}} function from a
#'\code{link[=mira-class]{mira}} object.  The \code{mipo} class of objects has methods for
#'the following generic functions: \code{print}, \code{summary}.
#'
#'@section Slots: 
#'  \describe{
#'    \item{\code{.Data}:}{Object of class \code{"list"} containing the 
#'    following slots:}
#'    \item{\code{call}:}{The call that created the \code{mipo} object.}
#'    \item{\code{call1}:}{The call that created the \code{mira} object that was used
#'in \code{call}.}
#'    \item{\code{call2}:}{ The call that created the \code{mids} object that was used
#'in \code{call1}.}
#'    \item{\code{data}:}{A copy of the incomplete data set.}
#'    \item{\code{nmis}:}{An array containing the number of missing observations per
#'column.}
#'    \item{\code{m}:}{Number of multiple imputations.}
#'    \item{\code{qhat}:}{An \code{m} by \code{npar} matrix containing the complete
#'data estimates for the \code{npar} parameters of the \code{m} complete data
#'analyses.}
#'    \item{\code{u}:}{An \code{m} by \code{npar} by \code{npar} array containing the
#'variance-covariance matrices of the estimates of the \code{m} complete data analyses.}
#'    \item{\code{qbar}:}{The average of complete data estimates. The multiple imputation estimate.}
#'    \item{\code{ubar}:}{The average of the variance-covariance matrix of the
#'complete data estimates.}
#'    \item{\code{b}:}{The between imputation variance-covariance matrix for the estimates.}
#'    \item{\code{t}:}{The total variance-covariance matrix for the estimates.}
#'    \item{\code{r}:}{Relative increases in variance due to missing data.}
#'    \item{\code{dfcom}:}{Degrees of freedom in the hypothetically complete data: the
#'sample size minus the number of free parameters.}
#'    \item{\code{df}:}{Degrees of freedom associated with the t-statistics.}
#'    \item{\code{fmi}:}{Fraction of missing information.}
#'    \item{\code{lambda}:}{Proportion of the variation attributable to the missing
#'data: \code{(b+b/m)/t.}}
#'}
#'
#'@note The functions of the \code{mice} package do not use the S4 class definitions, 
#' and instead rely on the S3 list equivalent \code{oldClass(obj) <- "mipo"}.
#' 
#'@name mipo-class
#'@rdname mipo-class
#'@aliases mipo-class mipo
#'@author Stef van Buuren, Karin Groothuis-Oudshoorn, 2000
#'@seealso \code{\link{pool}}, \code{\link[=mids-class]{mids}}, \code{\link[=mira-class]{mira}}
#'@references van Buuren S and Groothuis-Oudshoorn K (2011). \code{mice}:
#'Multivariate Imputation by Chained Equations in \code{R}. \emph{Journal of
#'Statistical Software}, \bold{45}(3), 1-67.
#'\url{http://www.jstatsoft.org/v45/i03/}
#'@keywords classes
#'@export
setClass("mipo",
         representation(
             call      = "call",
             call1     = "call",
             call2     = "call",
             data      = "data.frame" ,
             nmis      = "integer",
             m         = "numeric",
             qhat      = "matrix",
             u         = "array",
             qbar      = "numeric",
             ubar      = "matrix",
             b         = "matrix",
             t         = "matrix",
             r         = "numeric",
             dfcom     = "numeric",
             df        = "numeric",
             fmi       = "numeric",
             lambda    = "numeric"),
         contains  = "list"
)
