\name{mids}
\alias{mids}
\title{Multiply Imputed Data Set}
\alias{mids}
\alias{print.mids}
\alias{summary.mids}
\alias{plot.mids}
\usage{
\method{print}{mids}(x, \dots)
\method{summary}{mids}(object, \dots)
\method{plot}{mids}(x, y, \dots)
}

\description{An object containing a multiply imputed data set. The
  "mids" object is generated by the mice and mice.mids functions. The
  "mids" class of objects has methods for the following generic
  functions: \code{print}, \code{summary}, \code{plot}}

\arguments{
	\item{x}{A mids object.}
	\item{object}{A mids object.}
	\item{y}{Not used.}
	\item{\dots}{Not used.}
}

\value{
  \item{call}{  The call that created the object.}
  \item{data}{  A copy of the incomplete data set.}
  \item{m}{ The number of imputations.}
  \item{nmis}{  An array containing the number of missing observations per column.}
  \item{imp}{   A list of nvar components with the generated multiple imputations. 
    Each part of the list is a \code{nmis[j]} by m matrix of imputed values for 
    variable j.}
  \item{imputationMethod}{A vector of strings of length(nvar) specifying the elementary 
    imputation method per column.}
  \item{predictorMatrix}{
    A square matrix of size \code{ncol(data)} containing 0/1 data specifying 
    the predictor set.}
  \item{visitSequence}{
    The sequence in which columns are visited.}
  \item{seed}{  The seed value of the solution.}
  \item{iteration}{
    Last Gibbs sampling iteration number.}
  \item{lastSeedValue}{
    The most recent seed value.}
  \item{chainMean}{
    A list of m components. Each component is a \code{length(visitSequence)}
    by maxit matrix containing the mean of the generated multiple 
    imputations. The array can be used for monitoring convergence.
    Note that observed data are not present in this mean.}
  \item{chainCov}{
    A list with similar structure of itermean, containing the covariances 
    of the imputed values.}
  \item{pad}{   A list containing various settings of the padded imputation model, 
    i.e. the imputation model after creating dummy variables. Normally, 
    this array is only useful for error checking.}
}
\references{
  Van Buuren, S. & Oudshoorn, C.G.M. (2000). Multivariate Imputation by Chained Equations: 
  MICE V1.0 User's manual. Report PG/VGZ/00.038, TNO Prevention and Health, Leiden.
}

\author{Stef van Buuren, Karin Oudshoorn, 2000}     

\keyword{misc} 





