cesRssDeriv <- function( par, yName, xNames, data, vrs, rho1 = NULL,
      rho2 = NULL, rho = NULL, rhoApprox, nested = FALSE ) {

   # number of exogenous variables
   nExog <- length( xNames )

   # obtain names of coefficients
   coefNames <- cesCoefNames( nExog = nExog, vrs = vrs, 
      returnRho1 = is.null( rho1 ), returnRho2 = is.null( rho2 ), 
      returnRho = is.null( rho ), nested = nested )

   # check rhoApprox
   if( !nested ) {
      rhoApprox <- cesCheckRhoApprox( rhoApprox = rhoApprox, withY = TRUE,
         withDeriv = TRUE )
   }

   # add coefficients rho_1, rho_2, and rho, if they are fixed
   par <- cesCoefAddRho( coef = par, vrs = vrs, rho1 = rho1, rho2 = rho2, 
      rho = rho, nExog = nExog, nested = nested )

   # calculate fitted values and residuals
   yHat <- cesCalc( xNames = xNames, data = data, coef = par,
      rhoApprox = rhoApprox[1], nested = nested )
   resid <- data[[ yName ]] - yHat

   # obtain derivatives of the CES with respect to coefficients
   derivCoef <- cesDerivCoef( par = par, xNames = xNames, data = data, 
      vrs = vrs, returnRho1 = is.null( rho1 ), returnRho2 = is.null( rho2 ), 
      returnRho = is.null( rho ), rhoApprox = rhoApprox[-1],
      nested = nested )

   # prepare vector of gradients (to be returned)
   result <- numeric( ncol( derivCoef ) )
   names( result ) <- colnames( derivCoef )
   for( coefName in colnames( derivCoef ) ) {
      result[ coefName ] <- sum( - 2 * resid * derivCoef[ , coefName ] )
   }
   return( result )
}
