% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirna_year_new_and_trend.R
\name{plot_mir_development}
\alias{plot_mir_development}
\title{Plot development of miRNA name mentioning over time}
\usage{
plot_mir_development(
  df,
  mir,
  start = NULL,
  end = NULL,
  linetype = "miRNA",
  alpha = 0.8,
  width = 0.3,
  col.mir = miRNA,
  col.year = Year,
  title = NULL
)
}
\arguments{
\item{df}{Data frame containing miRNA names and publication years.}

\item{mir}{Character vector. Vector containing miRNA names to plot.}

\item{start}{Numeric. Optional. Specifies start year. If \code{start = NULL},
\code{start} is set to the oldest year in \code{df}.}

\item{end}{Numeric. Optional. Specifies end year. If \code{end = NULL},
\code{end} is set to the youngest year in \code{df}.}

\item{linetype}{String. Specifies linetype. \code{linetype} can take on values
as mentioned in the geom_line documentation of \pkg{ggplot2}. Additionally,
\code{linetype} can be set to \code{"miRNA"}. If \code{linetype = "miRNA"}, each miRNA name
in \code{mir} has its own linetype.}

\item{alpha}{Float. Opacity of lines.}

\item{width}{Float. Width of dodging lines.}

\item{col.mir}{Symbol. Column containing miRNA names.}

\item{col.year}{Symbol. Column containing year.}

\item{title}{String. Plot title.}
}
\value{
Line plot displaying how often a miRNA name was mentioned per year..
}
\description{
Plot development of miRNA name mentioning over time.
}
\details{
Plot how often a miRNA name was mentioned per year.
}
\seealso{
Other miR development functions: 
\code{\link{plot_mir_new}()}
}
\concept{miR development functions}
