% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_mir_terms.R
\name{compare_mir_terms}
\alias{compare_mir_terms}
\title{Compare count of terms associated with a miRNA name over various topics}
\usage{
compare_mir_terms(
  df,
  mir,
  top = 20,
  token = "words",
  ...,
  topic = NULL,
  shared = TRUE,
  normalize = TRUE,
  stopwords = stopwords_miretrieve,
  stopwords_ngram = TRUE,
  position = "dodge",
  col.mir = miRNA,
  col.abstract = Abstract,
  col.topic = Topic,
  col.pmid = PMID,
  title = NULL
)
}
\arguments{
\item{df}{Data frame containing miRNA names, abstracts, topics, and PubMed-IDs.}

\item{mir}{String. miRNA name of interest.}

\item{top}{Integer. Number of top terms to plot.}

\item{token}{String. Specifies how abstracts shall be split up. Taken from
\code{unnest_tokens()} in the \pkg{tidytext} package:
"Unit for tokenizing, or a custom tokenizing function. Built-in options are
"words" (default), "characters", "character_shingles", "ngrams", "skip_ngrams",
"sentences", "lines", "paragraphs", "regex",
(...),
and "ptb" (Penn Treebank). If a function, should take a character vector and
return a list of character vectors of the same length."}

\item{...}{Additional arguments for tokenization, if necessary.}

\item{topic}{Character vector. Optional. Specifies topics to plot.
If \code{topic = NULL}, all topics in \code{df} are plotted.}

\item{shared}{Boolean. If \code{shared = TRUE}, only terms that are shared
between all topics are plotted.}

\item{normalize}{Boolean. If \code{normalize = TRUE}, normalizes the number of
abstracts to the total number of abstracts with a miRNA name in a topic.}

\item{stopwords}{Data frame containing stop words.}

\item{stopwords_ngram}{Boolean. Specifies if stop words shall be removed
from abstracts when using ngrams. Only applied when \code{token = 'ngrams'}.}

\item{position}{Character vector. Vector containing either "dodge" or "facet".
Determines if bar plots are on top of or next to each other.}

\item{col.mir}{Symbol. Column containing miRNA names.}

\item{col.abstract}{Symbol. Column containing abstracts.}

\item{col.topic}{Symbol. Column containing topic names.}

\item{col.pmid}{Symbol. Column containing PubMed-IDs.}

\item{title}{String. Plot title.}
}
\value{
Bar plot comparing the count of terms associated with a
miRNA name over two topics.
}
\description{
Compare count of top terms associated with a miRNA name over various topics.
}
\details{
Compare count of top terms associated with a miRNA name
over various topics.
miRNA names and topics must be in a data frame \code{df}, while terms are taken
from abstracts contained in \code{df}.
Number of top terms to plot is regulated by \code{top}. Terms can either be
evaluated as their raw count, e.g. in how many abstracts they are mentioned
in conjunction with the miRNA name, or as their relative count, e.g.
in how many abstracts containing the miRNA they are mentioned compared to all
abstracts containing the miRNA.
\code{compare_mir_terms()} is based on the tools available in the
\pkg{tidytext} package.
}
\seealso{
\code{\link[=compare_mir_terms_log2]{compare_mir_terms_log2()}}, \code{\link[=compare_mir_terms_scatter]{compare_mir_terms_scatter()}}

Other compare functions: 
\code{\link{compare_mir_count_log2}()},
\code{\link{compare_mir_count_unique}()},
\code{\link{compare_mir_count}()},
\code{\link{compare_mir_terms_log2}()},
\code{\link{compare_mir_terms_scatter}()},
\code{\link{compare_mir_terms_unique}()}
}
\concept{compare functions}
