% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/milags_functions.R
\name{fit_exp_lag}
\alias{fit_exp_lag}
\title{fit_exp_lag}
\usage{
fit_exp_lag(data, tangent_method, n0, curve_points = 3)
}
\arguments{
\item{data}{a data frame with two required columns names: "time" and "biomass",and one optional column: "curve_id"
This is data from may come from multiple growth curves}

\item{tangent_method}{"local.regression" (if the tangent is fitted to a number of points around the maximal growth rate)
or "to.point" (if the tangent is fitted only to the point where the growth rate is maximal); defaults to "to.point"}

\item{n0}{the initial biomass (a tangent line crossing N0 line will determine the lag)}

\item{curve_points}{if tangent_method = "local.regression" then curve_points is the number of points the line is fitted to;
defaults to 3 i.e. the point with the maximal uptake rate one point before and one point aftter}
}
\value{
growth curve data (as input) together with additional columns: lag, line.intercept and line.slope
}
\description{
Fits the lag to multiple growth curves based on the basic tangent method
}
