\name{ plot.mi }
\alias{plot}
\alias{plot.mi}
\alias{plot,mi,missing-method}
\title{Diagnostic Plots for multiple imputation object}
\description{
  Diagnostic plots for testing the fit of the imputation method to the observed data.
}
\usage{
\S4method{plot}{mi,missing}( x, m = 1, vrb = NULL, vrb.name = "Variable Score",
                    gray.scale = FALSE, mfrow=c( 1, 4 ), \dots )
}
\arguments{
  \item{x}{ \code{mi} object generated by the mi function.}
  \item{m}{ The m-th imputation. By default is 1.}
  \item{vrb}{ A chosen variable for the scatter plot. }
  \item{vrb.name}{ A name of the vrb variable. }
  \item{gray.scale}{When set to \code{TRUE}, makes the plot into gray scale with predefined color and line type.}
  \item{mfrow}{See \dQuote{par} for details.}
  \item{\dots}{Arguments for other methods, not used.}
}
\details{
  For each variable, observed values are in blue, the imputed values are in red.  In the scatterplot the observed and the imputed are plotted versus a variable the users can choose. By default the values are plotted against an index number but it
strongly recommended to use a variable containing more information. Fitted lowess lines are also plotted for both observed and imputed data. A small amount of random noise (jittering) is added to the points so that they do not fall on top of each other. 
}

\value{
  Histograms, scatterplots, and residual plots of the fit of the imputation models.  
  Binned residual plots are for each dichotomous variable.
}
\references{
    Kobi Abayomi, Andrew Gelman and Marc Levy. (2008).
    \dQuote{Diagnostics for multivariate imputations}.
    \emph{Applied Statistics} 57, Part 3: 273--291.

    Andrew Gelman and Maria Grazia Pittau.
    \dQuote{A flexible program for missing-data imputation and model checking.}
    \emph{Technical report}. Columbia University, New York.
   
    Andrew Gelman and Jennifer Hill. (2007).
    \emph{Data Analysis Using Regression and Multilevel/Hierarchical Models}.
    Cambridge University Press.
}
\author{
  Masanao Yajima \email{yajima@stat.columbia.edu},
  Yu-Sung Su \email{ys463@columbia.edu},
  M.Grazia Pittau \email{grazia@stat.columbia.edu},
  Andrew Gelman \email{gelman@stat.columbia.edu}
}

\seealso{
  \code{\link{mi}}, 
  \code{\link{mi.scatterplot}},
  \code{\link{mi.hist}}
}
\examples{
  data(CHAIN)
  imp.CHAIN <- mi(CHAIN, n.iter=6, preprocess=FALSE, 
    add.prior=prior.control(K=0))
  plot(imp.CHAIN)
}
\keyword{ hplot }
