% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missNames_function.R
\name{missNames}
\alias{missNames}
\title{Idenify genes with missing names}
\usage{
missNames(mgl)
}
\arguments{
\item{mgl}{Object of class 'mgl'; see \code{\link{buildFromNames}}, \code{\link{buildFromRegion}}, or \code{\link{buildFromEnsgs}}}
}
\description{
\code{missNames} returns gene names that were not found in ensembl
}
\details{
This gives a vector of gene names where basic information on gene nomenclature in particular identification of the unambiguous ENSG identifier was NOT found.
}
\section{Details}{

If a gene is not found, a warning message will appear: 'Gene names missing: ...'.  This must be corrected or no other elements can be filled in as the remaining elements all build off of the disambigous ENSG identifier.  There are two strategies to fix this.  The first is to check gene names for typos or use of less common colloquial names.  The second is to use the missNames and fixNames functions in this pacakge to fill in the missing ENSG identifiers.  Note: googling the colloquial gene name and 'gene cards' is an excellent way to find an ENSG id.  Genecards does an exceptional job of cataloging alternative colloquial names.
}
\examples{
\dontrun{buildFromNames(c('CETP', 'APBO'), elements = 
c('name', 'enst', 'location', 'antisense')) -> myMgl}
\dontrun{missNames(myMgl)}

}
\seealso{
\code{\link{fixNames}}

Other elements: \code{\link{addAei}},
  \code{\link{addAntisense}}, \code{\link{addCisEqtl}},
  \code{\link{addDnase}}, \code{\link{addEnst}},
  \code{\link{addExpression}}, \code{\link{addGo}},
  \code{\link{addGrasp}}, \code{\link{addGwasCatalog}},
  \code{\link{addLoc}}, \code{\link{addPtv}},
  \code{\link{addPubmed}}, \code{\link{addSqtlAltrans}},
  \code{\link{addSqtlSeek}}, \code{\link{addTransEqtl}}
}

