% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addAei_function.R
\name{addAei}
\alias{addAei}
\title{Add allele specific expression data to list}
\usage{
addAei(mgl, fpsource)
}
\arguments{
\item{mgl}{List; see \code{\link{buildFromNames}}, \code{\link{buildFromRegion}}, or \code{\link{buildFromEnsgs}}}

\item{fpsource}{A character string of with the filepath where the data has been downloaded}
}
\description{
\code{addAei} returns a list with the twentieth element as dataframe with allele specific data from GTEx.
}
\details{
This gives allele specific expression RNAsequencing data as reported by GTEx for the gene of interest.  See \url{http://www.gtexportal.org/}.  It pulls data based on the ENSG identifier.
}
\examples{
\dontrun{buildFromRegion(chr = 2, start = 102314000, stop = 103435000) -> myMgl}
\dontrun{myMgl <- addAei(myMgl, fpsource = "/Downloads")}

}
\seealso{
Other elements: \code{\link{addAntisense}},
  \code{\link{addCisEqtl}}, \code{\link{addDnase}},
  \code{\link{addEnst}}, \code{\link{addExpression}},
  \code{\link{addGo}}, \code{\link{addGrasp}},
  \code{\link{addGwasCatalog}}, \code{\link{addLoc}},
  \code{\link{addPtv}}, \code{\link{addPubmed}},
  \code{\link{addSqtlAltrans}}, \code{\link{addSqtlSeek}},
  \code{\link{addTransEqtl}}, \code{\link{missNames}}
}

