% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addPtv_function.R
\name{addPtv}
\alias{addPtv}
\title{Add results from protein truncating variant algorithm made available by GTEx}
\usage{
addPtv(mgl, range = 0, download = T, saveDownload = F, fpsource = "./")
}
\arguments{
\item{mgl}{List; see \code{\link{buildFromNames}}, \code{\link{buildFromRegion}}, or \code{\link{buildFromEnsgs}}}

\item{range}{Number indicating distance upstream of start and downstream of stop that should be used for filtering SNPs.}

\item{download}{A logical vector indicating if the data should be downloaded.}

\item{saveDownload}{A logical vector indicating if the data should be saved as 'RawData_Ptv.RData'}

\item{fpsource}{A character string of with the filepath where the data has been downloaded}
}
\description{
\code{addPtv} returns an 'mgl' list with the seventeenth element as a dataframe containing results from psiQTL algorithm; see \url{http://www.gtexportal.org/home/}.
}
\details{
This gives the protein truncating variant results for each gene.  Data was originally downloaded from the GTEx website \url{http://www.gtexportal.org/static/datasets/gtex_analysis_pilot_v3/ptv_data/gtex_psiqtls.zip}.
}
\examples{
\dontrun{buildFromRegion(chr = 2, start = 102314000, stop = 103435000) -> myMgl}
\dontrun{myMgl <- addPtv(myMgl, range = 0)}

}
\seealso{
Other elements: \code{\link{addAei}},
  \code{\link{addAntisense}}, \code{\link{addCisEqtl}},
  \code{\link{addDnase}}, \code{\link{addEnst}},
  \code{\link{addExpression}}, \code{\link{addGo}},
  \code{\link{addGrasp}}, \code{\link{addGwasCatalog}},
  \code{\link{addLoc}}, \code{\link{addPubmed}},
  \code{\link{addSqtlAltrans}}, \code{\link{addSqtlSeek}},
  \code{\link{addTransEqtl}}, \code{\link{missNames}}
}

