% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lauricella.R
\name{lauricella}
\alias{lauricella}
\title{Lauricella \eqn{D}-Hypergeometric Function}
\usage{
lauricella(a, b, g, x, eps = 1e-06)
}
\arguments{
\item{a}{numeric.}

\item{b}{numeric vector.}

\item{g}{numeric.}

\item{x}{numeric vector. \code{x} must have the same length as \code{b}.}

\item{eps}{numeric. Precision for the nested sums (default 1e-06).}
}
\value{
A numeric value: the value of the Lauricella function,
with two attributes \code{attr(, "epsilon")} (precision of the result) and \code{attr(, "k")} (number of iterations).
}
\description{
Computes the Lauricella \eqn{D}-hypergeometric Function function.
}
\details{
If \eqn{n} is the length of the \eqn{b} and \code{x} vectors,
the Lauricella \eqn{D}-hypergeometric Function function is given by:
\deqn{\displaystyle{F_D^{(n)}\left(a, b_1, ..., b_n, g; x_1, ..., x_n\right) = \sum_{m_1 \geq 0} ... \sum_{m_n \geq 0}{ \frac{ (a)_{m_1+...+m_n}(b_1)_{m_1} ... (b_n)_{m_n} }{ (g)_{m_1+...+m_n} } \frac{x_1^{m_1}}{m_1!} ... \frac{x_n^{m_n}}{m_n!} } }}

where \eqn{(x)_p} is the Pochhammer symbol (see \code{\link{pochhammer}}).

If \eqn{|x_i| < 1, i = 1, \dots, n}, this sum converges.
Otherwise there is an error.

The \code{eps} argument gives the required precision for its computation.
It is the \code{attr(, "epsilon")} attribute of the returned value.

Sometimes, the convergence is too slow and the required precision cannot be reached.
If this happens, the \code{attr(, "epsilon")} attribute is the precision that was really reached.
}
\references{
N. Bouhlel, A. Dziri, Jullback-Leibler Divergence Between Multivariate Generalized Gaussian Distributions.
IEEE Signal Processing Letters, vol. 26 no. 7, July 2019.
\doi{10.1109/LSP.2019.2915000}
}
\author{
Pierre Santagostini, Nizar Bouhlel
}
