% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getViz.R
\name{getViz}
\alias{getViz}
\title{Converting gam objects to gamViz objects}
\usage{
getViz(o, nsim = 0, ...)
}
\arguments{
\item{o}{an object of class \code{gam}.}

\item{nsim}{the number of simulated vectors of responses. A positive integer.}

\item{...}{extra arguments to be passed to \code{simulate.gam}}
}
\value{
An object of class \code{gamViz}.
}
\description{
This function converts \code{gam} objects into \code{gamViz} objects,
for which \code{mgcViz} provides several plotting methods.
}
\examples{
library(mgcViz)
set.seed(2) ## simulate some data...
dat <- gamSim(1,n=1000,dist="normal",scale=2)
b <- gam(y~s(x0)+s(x1, x2)+s(x3), data=dat, method="REML")
b <- getViz(b, nsim = 20)
str(b$store$sim) # Simulated responses now stored here

plot(sm(b,1)) + l_fitLine() + l_ciLine() + l_rug() + l_points()
plot(sm(b,2)) + l_rug() + l_fitRaster() + l_fitContour()
}
