% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_mfp.R
\name{fit_mfp}
\alias{fit_mfp}
\title{Function for fitting a model using the MFP or MFPA algorithm}
\usage{
fit_mfp(
  x,
  y,
  weights,
  offset,
  cycles,
  scale,
  shift,
  df,
  center,
  family,
  criterion,
  select,
  alpha,
  keep,
  xorder,
  powers,
  method,
  strata,
  nocenter,
  acdx,
  ftest,
  control,
  verbose
)
}
\arguments{
\item{x}{an input matrix of dimensions nobs x nvars. Does not contain
intercept, but columns are already expanded into dummy variables as
necessary. Data are assumed to be shifted and scaled.}

\item{y}{a vector for the response variable or a \code{Surv} object.}

\item{weights}{a vector of observation weights of length nobs.}

\item{offset}{a vector of length nobs of offsets.}

\item{cycles}{an integer representing the maximum number of
iteration cycles during which FP powers for all predictor are updated.}

\item{scale}{a numeric vector of length nvars of scaling factors. Not applied,
but re-ordered to conform to \code{xorder}.}

\item{shift}{a numeric vector of length nvars of shifts. Not applied,
but re-ordered to conform to \code{xorder}.}

\item{df}{a numeric vector of length nvars of degrees of freedom.}

\item{center}{a logical vector of length nvars indicating if variables are
to be centered.}

\item{family}{a character string representing a family object.}

\item{criterion}{a character string defining the criterion used to select
variables and FP models of different degrees.}

\item{select}{a numeric vector of length nvars indicating significance levels
for backward elimination.}

\item{alpha}{a numeric vector of length nvars indicating significance levels
for tests between FP models of different degrees.}

\item{keep}{a character vector with names of variables to be kept
in the model.}

\item{xorder}{a string determining the order of entry of the covariates
into the model-selection algorithm.}

\item{powers}{a named list of numeric values that sets the permitted FP
powers for each covariate.}

\item{method}{a character string specifying the method for tie handling in
Cox regression model.}

\item{strata}{a factor of all possible combinations of stratification
variables. Returned from \code{\link[survival:strata]{survival::strata()}}.}

\item{nocenter}{a numeric vector with a list of values for fitting Cox
models. See \code{\link[survival:coxph]{survival::coxph()}} for details.}

\item{acdx}{a logical vector of length nvars indicating which continuous
variables should undergo the approximate cumulative distribution (ACD)
transformation.}

\item{ftest}{a logical indicating the use of the F-test for Gaussian models.}

\item{control}{a list with parameters for model fit. See \code{\link[survival:coxph]{survival::coxph()}}
or \code{\link[stats:glm]{stats::glm()}} for details.}

\item{verbose}{a logical; run in verbose mode.}
}
\value{
See \code{\link[=mfp2]{mfp2()}} for details on the returned object.
}
\description{
This function is not exported and is intended to be called from
the \code{\link[=mfp2]{mfp2()}} function. While most parameters are explained in
the documentation of \code{mfp2()}, their form may differ in this
function. Note that this function does not check its arguments
and expects that its input has been prepared in \code{mfp2()} function.
}
\section{Algorithm}{

\itemize{
\item Step 1: order variables according to \code{xorder}. This step may involve
fitting a regression model to determine order of significance.
\item Step 2: input data pre-processing. Setting initial powers for fractional
polynomial terms, checking if acd transformation is required and allowed.
Note that the initial powers of all variables are always set to 1, and higher
FPs are only evaluated in turn for each variables in the first cycle of the
algorithm. See e.g. Sauerbrei and Royston (1999).
\item Step 3: run mfp algorithm cycles. See \code{\link[=find_best_fp_cycle]{find_best_fp_cycle()}} for more
details.
\item Step 4: fit final model using estimated powers.
}
}

\references{
Sauerbrei, W. and Royston, P., 1999. \emph{Building multivariable prognostic
and diagnostic models: transformation of the predictors by using fractional
polynomials. J Roy Stat Soc a Sta, 162:71-94.}
}
\seealso{
\code{\link[=mfp2]{mfp2()}}, \code{\link[=find_best_fp_cycle]{find_best_fp_cycle()}}
}
