% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univdist.R
\name{gpdN}
\alias{gpdN}
\title{Generalized Pareto distribution (mean of maximum of N exceedances parametrization)}
\arguments{
\item{par}{vector of length 2 containing \eqn{z} and \eqn{\xi}, respectively the mean excess of the maxima of N exceedances above the threshold and the shape parameter.}

\item{dat}{sample vector}

\item{N}{block size for threshold exceedances.}

\item{tol}{numerical tolerance for the exponential model}

\item{V}{vector calculated by \code{gpdN.Vfun}}
}
\description{
Likelihood, score function and information matrix,
approximate ancillary statistics and sample space derivative
for the generalized Pareto distribution parametrized in terms of average maximum of \code{N} exceedances.

The parameter \code{N} corresponds to the number of threshold exceedances of interest over which the maxima is taken.
\eqn{z} is the corresponding expected value of this block maxima.
Note that the actual parametrization is in terms of excess expected mean, meaning expected mean minus threshold.
}
\details{
The observed information matrix was calculated from the Hessian using symbolic calculus in Sage.
}
\section{Usage}{
 \preformatted{gpdN.ll(par, dat, N, tol=1e-5)
gpdN.score(par, dat, N)
gpdN.infomat(par, dat, N, method = c('obs', 'exp'), nobs = length(dat))
gpdN.Vfun(par, dat, N)
gpdN.phi(par, dat, N, V)
gpdN.dphi(par, dat, N, V)}
}

\section{Functions}{


\itemize{
\item{\code{gpdN.ll}:} {log likelihood}
\item{\code{gpdN.score}:} {score vector}
\item{\code{gpdN.infomat}:} {observed information matrix for GP parametrized in terms of mean of the maximum of \code{N} exceedances and shape}
\item{\code{gpdN.Vfun}:} {vector implementing conditioning on approximate ancillary statistics for the TEM}
\item{\code{gpdN.phi}:} {canonical parameter in the local exponential family approximation}
\item{\code{gpdN.dphi}:} {derivative matrix of the canonical parameter in the local exponential family approximation}
}
}

\author{
Leo Belzile
}
