% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univdist.R
\name{gevN.temstat}
\alias{gevN.temstat}
\alias{gevN.Vfun}
\alias{gevN.phi}
\alias{gevN.dphi}
\title{Tangent exponential model statistics for the generalized Pareto distribution (mean of maximum of N exceedances parametrization)}
\usage{
gevN.Vfun(par, dat, N, q = 0.5, qty = c("mean", "quantile"))

gevN.phi(par, dat, N, q = 0.5, qty = c("mean", "quantile"), V)

gevN.dphi(par, dat, N, q = 0.5, qty = c("mean", "quantile"), V)
}
\arguments{
\item{par}{vector of \code{loc}, quantile/mean of N-block maximum and \code{shape}}

\item{dat}{sample vector}

\item{q}{probability, corresponding to \eqn{q}th quantile of the \code{N}-block maximum}

\item{qty}{string indicating whether to calculate the \code{q} quantile or the mean}

\item{V}{vector calculated by \code{gevN.Vfun}}
}
\description{
Vector implementing conditioning on approximate ancillary statistics for the TEM

Canonical parameter in the local exponential family approximation
}
\seealso{
\code{\link{gevN}}
}
\keyword{internal}
