% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infomat_test.R
\name{ext.index}
\alias{ext.index}
\title{Extremal index estimators based on interexceedance time and gap of exceedances}
\usage{
ext.index(x, q = 0.95, method = c("wls", "mle", "intervals"),
  plot = FALSE)
}
\arguments{
\item{x}{a vector containing of data points}

\item{q}{a vector of quantile levels in (0,1). Defaults to 0.95}

\item{method}{a string specifying the chosen method. Must be either \code{wls}
for weighted least squares, \code{mle} for maximum likelihood estimation or \code{intervals}
for the intervals estimator of Ferro and Segers (2003). Partial match is allowed.}

\item{plot}{a boolean specifying whether to plot the extremal index as a function of \code{q}}
}
\value{
a vector or matrix of estimated extremal index of dimension \code{length(method)} by \code{length(q)}.
}
\description{
The function implements the maximum likelihood estimator and iteratively reweigthed least
square estimators of Suveges (2007)  as well as the intervals estimator. The implementation
differs from the presentation of the paper in that an iteration limit is enforced to make sure
the iterative procedure terminates. sMultiple thresholds can be supplied
}
\details{
The iteratively reweighted least square is a procedure based on the gaps of exceedances \eqn{S_n=T_n-1}{Tn-1}
The model is first fitted to non-zero gaps, which are rescaled to have unit exponential scale. The slope
between the theoretical quantiles and the normalized gap of exceedances is \eqn{b=1/\theta}{b=1/\theta},
with intercept \eqn{a=\log(\theta)/\theta}{a=log(\theta)/\theta}.
As such, the estimate of the extremal index is based on \eqn{\hat{\theta}=\exp(\hat{a}/\hat{b})}{\theta=exp(a/b)}.
The weights are chosen in such a way as to reduce the influence of the smallest values.
The estimator exploits the dual role of \eqn{\theta}{theta} as the parameter of the mean for
the interexceedance time as well as the mixture proportion for the non-zero component.

The maximum likelihood is based on an independence likelihood for the rescaled gap of exceedances,
namely \eqn{\bar{F}(u_n)S(u_n)}{(1-F(u))*S(u)}. The score equation is equivalent to a quadratic equation in
\eqn{\theta}{theta} and the maximum likelihood estimate is available in closed form.
Its validity requires however condition \eqn{D^{(2)}(u_n)}{D2(u)} to apply;
this should be checked by the user beforehand.

A warning is emitted if the effective sample size is less than 50 observations.
}
\examples{
set.seed(234)
#Moving maxima model with theta=0.5
a <- 1; theta <-  1/(1+a)
sim <- evd::rgev(10001, loc=1/(1+a),scale=1/(1+a),shape=1)
x <- pmax(sim[-length(sim)]*a,sim[-1])
q <- seq(0.9,0.99,by=0.01)
ext.index(x=x,q=q,method=c("wls","mle"))
}
\references{
Ferro and Segers (2003). Inference for clusters of extreme values,
JRSS: Series B, \strong{65}(2), 545-556.

Suveges (2007) Likelihood estimation of the extremal index. \emph{Extremes},
 \strong{10}(1), 41-55.

Suveges and Davison (2010), Model misspecification in peaks over threshold analysis. \emph{Annals of Applied Statistics}, \strong{4}(1), 203-221.

Fukutome, Liniger and Suveges (2015), Automatic threshold and run parameter selection: a climatology
for extreme hourly precipitation in Switzerland. \emph{Theoretical and Applied Climatology},
\strong{120}(3), 403-416.
}
\author{
Leo Belzile
}
