% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phreg.R
\name{aalenMets}
\alias{aalenMets}
\title{Fast additive hazards model with robust standard errors}
\usage{
aalenMets(formula, data = data, ...)
}
\arguments{
\item{formula}{formula with 'Surv' outcome (see \code{coxph})}

\item{data}{data frame}

\item{...}{Additional arguments to phreg}
}
\description{
Fast Lin-Ying additive hazards model with a possibly stratified baseline. 
Robust variance is default variance with the summary.
}
\details{
influence functions (iid) will follow numerical order of given cluster variable
so ordering after $id will give iid in order of data-set.
}
\examples{

data(bmt)
out <- aalenMets(Surv(time,cause==1)~tcell+platelet+age,data=bmt)
summary(out)

}
\author{
Thomas Scheike
}
