% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dutils.R
\name{dprint}
\alias{dhead}
\alias{dlist}
\alias{dprint}
\alias{dtail}
\title{list, head, print, tail}
\usage{
dprint(data, y = NULL, n = 0, ..., x = NULL)
}
\arguments{
\item{data}{if x is formula or names for data frame then data frame is needed.}

\item{y}{name of variable, or fomula, or names of variables on data frame.}

\item{n}{Index of observations to print (default c(1:nfirst, n-nlast:nlast)}

\item{...}{Optional additional arguments (nfirst,nlast, and print options)}

\item{x}{possible group variable}
}
\description{
listing for data frames
}
\examples{
n <- 20
m <- lava::lvm(letters)
d <- lava::sim(m,n)

dlist(d,~a+b+c)
dlist(d,~a+b+c|a<0 & b>0)
## listing all : 
dlist(d,~a+b+c|a<0 & b>0,n=0)
dlist(d,a+b+c~I(d>0)|a<0 & b>0)
dlist(d,.~I(d>0)|a<0 & b>0)
dlist(d,~a+b+c|a<0 & b>0, nlast=0)
dlist(d,~a+b+c|a<0 & b>0, nfirst=3, nlast=3)
dlist(d,~a+b+c|a<0 & b>0, 1:5)
dlist(d,~a+b+c|a<0 & b>0, -(5:1))
dlist(d,~a+b+c|a<0 & b>0, list(1:5,50:55,-(5:1)))
dprint(d,a+b+c ~ I(d>0) |a<0 & b>0, list(1:5,50:55,-(5:1)))
}
\author{
Klaus K. Holst and Thomas Scheike
}

