% Generated by roxygen2 (4.0.1): do not edit by hand
\name{bicomprisk}
\alias{bicomprisk}
\title{Estimation of concordance in bivariate competing risks data}
\usage{
bicomprisk(formula, data, cause = c(1, 1), cens = 0, causes, indiv,
  strata = NULL, id, num, max.clust = 1000, marg = NULL,
  se.clusters = NULL, prodlim = FALSE, messages = TRUE, model,
  return.data = 0, uniform = 0, conservative = 1, resample.iid = 1, ...)
}
\arguments{
\item{formula}{Formula with left-hand-side being a \code{Event} object (see example below) and the left-hand-side specying the covariate structure}

\item{data}{Data frame}

\item{cause}{Causes (default (1,1)) for which to estimate the bivariate cumulative incidence}

\item{cens}{The censoring code}

\item{causes}{causes}

\item{indiv}{indiv}

\item{strata}{Strata}

\item{id}{Clustering variable}

\item{num}{num}

\item{max.clust}{max number of clusters in comp.risk call for iid decompostion, max.clust=NULL uses all clusters otherwise rougher grouping.}

\item{marg}{marginal cumulative incidence to make stanard errors for same clusters for subsequent use in casewise.test()}

\item{se.clusters}{to specify clusters for standard errors. Either a vector of cluster indices or a column name in \code{data}. Defaults to the \code{id} variable.}

\item{prodlim}{prodlim to use prodlim estimator (Aalen-Johansen) rather than IPCW weighted estimator based on comp.risk function.These are equivalent in the case of no covariates.}

\item{messages}{Control amount of output}

\item{model}{Type of competing risk model (default is Fine-Gray model "fg", see comp.risk).}

\item{return.data}{Should data be returned (skipping modeling)}

\item{uniform}{to compute uniform standard errors for concordance estimates based on resampling.}

\item{conservative}{for conservative standard errors, recommended for larger data-sets.}

\item{resample.iid}{to return iid residual processes for further computations such as tests.}

\item{...}{Additional arguments to lower level functions}
}
\description{
Estimation of concordance in bivariate competing risks data
}
\examples{
data(prt) ## Prostate data example (sim)
## Bivariate competing risk, concordance estimates
p33 <- bicomprisk(Event(time,status)~strata(zyg)+id(id),
                  data=prt,cause=c(2,2),return.data=1)

p33mz <- p33$model$"MZ"$comp.risk
## Concordance
plot(p33mz,ylim=c(0,0.1),axes=FALSE); axis(2); axis(1)
}
\author{
Thomas Scheike, Klaus K. Holst
}

