% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/base.R
\name{metropolis.control}
\alias{metropolis.control}
\title{metropolis.control}
\usage{
metropolis.control(
  adapt.start = 25,
  adapt.window = 200,
  adapt.update = 25,
  min.sigma = 0.001,
  prop.sigma.start = 1,
  scale = 2.4
)
}
\arguments{
\item{adapt.start}{start adapting after this many iterations; set to iter+1 to turn off adaptation}

\item{adapt.window}{base acceptance rate on maximum of this many iterations}

\item{adapt.update}{frequency of adaptation}

\item{min.sigma}{minimum of the proposal distribution standard deviation (if set to zero, 
posterior may get stuck)}

\item{prop.sigma.start}{starting value, or fixed value for proposal distribution s
standard deviation}

\item{scale}{scale value for adaptation (how much should the posterior
variance estimate be scaled by?). Scale/sqrt(p) is used in metropolis_glm function, and 
Gelman et al. (2014, ISBN: 9781584883883) recommend a scale of 2.4
@return A list of parameters used in fitting with the following named objects
  adapt.start, adapt.window,adapt.update,min.sigma,prop.sigma.start,scale}
}
\description{
metropolis.control
}
