% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotate.r
\name{mjs_add_marker}
\alias{mjs_add_marker}
\title{Sets a marker line/label}
\usage{
mjs_add_marker(mjs, x_value, label)
}
\arguments{
\item{mjs}{metricsgraphics plot object}

\item{x_value}{which x value to draw the marker at}

\item{label}{text label for the marker}
}
\value{
metricsgraphics object
}
\description{
metricsgraphics marker lines are vertical lines that identify, say, events or
dates worth annotating. This function lets you add a marker to a plot object.
you can add as many as you need to.
}
\examples{
data.frame(
  year=seq(1790, 1970, 10),
  uspop=as.numeric(uspop)
) \%>\%
  mjs_plot(x=year, y=uspop) \%>\%
  mjs_line() \%>\%
  mjs_add_marker(1850, "Something Wonderful") \%>\%
  mjs_add_baseline(150, "Something Awful")
}

