% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_balacc.R
\name{balacc}
\alias{balacc}
\title{Balanced Accuracy}
\usage{
balacc(data = NULL, obs, pred, pos_level = 2, tidy = FALSE, na.rm = TRUE)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (character | factor).}

\item{pred}{Vector with predicted values (character | factor).}

\item{pos_level}{Integer, for binary cases, indicating the order (1|2) of the level
corresponding to the positive. Generally, the positive level is the second (2)
since following an alpha-numeric order, the most common pairs are
\code{(Negative | Positive)}, \code{(0 | 1)}, \code{(FALSE | TRUE)}. Default : 2.}

\item{tidy}{Logical operator (TRUE/FALSE) to decide the type of return. TRUE
returns a data.frame, FALSE returns a list; Default : FALSE.}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric} within a \code{list} (if tidy = FALSE) or within a
\verb{data frame} (if tidy = TRUE).
}
\description{
It estimates the balanced accuracy for a nominal/categorical predicted-observed dataset.
}
\details{
The balanced accuracy is the average between recall and specificity.
It is particularly useful when the number of observation belonging to each class
is despair or imbalanced, and when especial attention is given to the negative
cases. It is bounded between 0 and 1. Values towards zero indicate low performance.
The closer to 1 the better.

For the formula and more details, see
\href{https://adriancorrendo.github.io/metrica/articles/available_metrics_classification.html}{online-documentation}
}
\examples{
\donttest{
set.seed(123)
# Two-class
binomial_case <- data.frame(labels = sample(c("True","False"), 100, replace = TRUE), 
predictions = sample(c("True","False"), 100, replace = TRUE))
# Multi-class
multinomial_case <- data.frame(labels = sample(c("Red","Blue", "Green"), 100, replace = TRUE),
predictions = sample(c("Red","Blue", "Green"), 100, replace = TRUE)    )

# Get balanced accuracy estimate for two-class case
balacc(data = binomial_case, obs = labels, pred = predictions, tidy = TRUE)

# Get balanced accuracy estimate for the multi-class case
balacc(data = multinomial_case, obs = labels, pred = predictions, tidy = TRUE)
}
}
\references{
García, V., Mollineda, R.A., Sánchez, J.S. (2009). Index of Balanced Accuracy:
A Performance Measure for Skewed Class Distributions.
\emph{In: Araujo, H., Mendonça, A.M., Pinho, A.J., Torres, M.I. (eds) Pattern Recognition and Image Analysis.}
\emph{IbPRIA 2009. Lecture Notes in Computer Science, vol 5524.}
\emph{Springer-Verlag Berlin Heidelberg.} \doi{10.1007/978-3-642-02172-5_57}
}
