% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bland_altman_plot.R
\name{bland_altman_plot}
\alias{bland_altman_plot}
\title{Bland-Altman plot}
\usage{
bland_altman_plot(data = NULL, obs, pred, na.rm = TRUE)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (numeric).}

\item{pred}{Vector with predicted values (numeric).}

\item{na.rm}{Logic argument to remove rows with missing values}
}
\value{
an object of class \code{ggplot}.
}
\description{
It creates a scatter plot of the difference between observed and predicted
values (obs-pred) vs. observed values.
}
\details{
See \href{https://adriancorrendo.github.io/metrica/articles/available_metrics.html}{online-documentation}
}
\examples{
\donttest{
X <- rnorm(n = 100, mean = 0, sd = 10)
Y <- rnorm(n = 100, mean = 0, sd = 10)
bland_altman_plot(obs = X, pred = Y)
}
}
\references{
Bland & Altman (1986).
Statistical methods for assessing agreement between two methods of clinical measurement
\emph{The Lancet 327(8476), 307-310} \doi{10.1016/S0140-6736(86)90837-8}
}
\seealso{
\code{\link[ggplot2]{ggplot}},\code{\link[ggplot2]{geom_point}},\code{\link[ggplot2]{aes}}
}
