% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_reshape_meteo.R
\name{meteospain2meteoland}
\alias{meteospain2meteoland}
\title{From meteospain to meteoland meteo objects}
\usage{
meteospain2meteoland(meteo, complete = FALSE)
}
\arguments{
\item{meteo}{meteospain meteo object.}

\item{complete}{logical indicating if the meteo data missing variables
should be calculated (if possible). Default to FALSE.}
}
\value{
a compatible meteo object to use with meteoland.
}
\description{
Adapting meteospain meteo objects to meteoland meteo objects
}
\details{
This function converts \code{meteospain} R package meteo objects to
compatible meteoland meteo objects by selecting the needed variables and
adapting the names to comply with meteoland requirements.
}
\examples{

if (interactive()) {
  # meteospain data
  library(meteospain)
  mg_april_2022_data <- get_meteo_from(
    "meteogalicia",
    meteogalicia_options("daily", as.Date("2022-04-01"), as.Date("2022-04-30"))
  )

  # just convert
  meteospain2meteoland(mg_april_2022_data)
  # convert and complete
  meteospain2meteoland(mg_april_2022_data, complete = TRUE)

}

}
