% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readWindNinjaOutput.R
\name{readWindNinjaWindFields}
\alias{readWindNinjaWindFields}
\title{Reads WindNinja results}
\usage{
readWindNinjaWindFields(
  filebase,
  resolution = "100m",
  directionClasses = c(0, 45, 90, 135, 180, 225, 270, 315),
  speedClasses = c(5, 15, 25),
  proj4string = CRS(as.character(NA))
)
}
\arguments{
\item{filebase}{A string to indicate the template for accessing WindNinja
files. Resolution, wind directions and wind speed class values are appended
to this string to obtain the filename to read.}

\item{resolution}{Resolution string.}

\item{directionClasses}{A vector of wind speed directions (in degrees).}

\item{speedClasses}{A vector of wind class values (in m/s).}

\item{proj4string}{Object of class \code{"CRS"} with the projection string
of wind field rasters.}
}
\value{
A list with the following items: \itemize{
\item\code{directionClasses}: The vector of wind direction classes.
\item\code{speedClasses}: The vector of wind speed classes.
\item\code{indexTable}: A numeric matrix indicating the raster index of each
combination of domain-level wind directions and wind speed classes.
\item\code{windSpeed}: An object of class \code{\link{SpatialGridDataFrame}}
containing wind speed rasters (in m/s) for each combination of domain-level
wind direction and wind speed.  \item\code{windDirection}: An object of
class \code{\link{SpatialGridDataFrame}} containing wind direction rasters
(in degrees from North) for each combination of domain-level wind direction
and wind speed. }
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Reads the wind fields generated by 'WindNinja'
(http://www.firelab.org/project/windninja) for combinations of domain-level
wind speed and wind direction classes.
}
\note{
WindNinja should be run with m/s as wind speed units and for all the
combinations of domain-level wind speed and wind direction required.
}
\references{
Forthofer, J.M., Butler, B.W., Wagenbrenner, N.S., 2014. A
comparison of three approaches for simulating fine-scale surface winds in
support of wildland fire management. Part I. Model formulation and
comparison against measurements. Int. J. Wildl. Fire 23, 969–981.
}
\seealso{
\code{\link{MeteorologyInterpolationData}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
