% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correctionpoints.R
\name{correction_series}
\alias{correction_series}
\title{Low-level correction functions}
\usage{
correction_series(
  obs,
  mod,
  proj = NULL,
  method = "unbias",
  isPrec = TRUE,
  qstep = 0.01
)
}
\arguments{
\item{obs}{Observed series for the reference (historical) period.}

\item{mod}{Modelled series for the reference (historical) period.}

\item{proj}{Modelled series for the projected period. If missing, the
reference (historical) period is corrected.}

\item{method}{Correction method, either \code{"unbias"}, \code{"scaling"},
\code{"quantmap"}}

\item{isPrec}{A flag to indicate that variable is precipitation (only
relevant for quantile mapping).}

\item{qstep}{Probability step for quantile mapping (see
\code{\link{defaultCorrectionParams}}).}
}
\value{
Returns a vector with corrected values.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

Low-level function to perform bias correction.
}
\references{
De Caceres M, Martin-StPaul N, Turco M, Cabon A, Granda V (2018)
Estimating daily meteorological data and downscaling climate models over
landscapes. Environmental Modelling and Software 108: 186-196.
}
\seealso{
\code{\link{correctionpoints}},
\code{\link{defaultCorrectionParams}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
