% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_cluster.R
\name{get_representative_solutions}
\alias{get_representative_solutions}
\title{Extract representative solutions from a matrix of ARIs}
\usage{
get_representative_solutions(
  aris,
  split_vector,
  order,
  solutions_matrix,
  filter_fn = NULL
)
}
\arguments{
\item{aris}{Matrix of adjusted rand indices from \code{calc_aris()}}

\item{split_vector}{A vector of partition indices.}

\item{order}{Numeric vector indicating row ordering of settings matrix.}

\item{solutions_matrix}{Output of \code{batch_snf} containing cluster solutions.}

\item{filter_fn}{Optional function to filter the meta-cluster by prior to
maximum average ARI determination. This can be useful if you are explicitly
trying to select a solution that meets a certain condition, such as only
picking from the 4 cluster solutions within a meta cluster. An example
valid function could be \code{fn <- function(x) x[x$"nclust" == 4, ]}.}
}
\value{
A "data.frame" class object corresponding to a subset of the
provided solutions matrix in which only one row is present per meta cluster.
}
\description{
Following clustering with \code{batch_snf}, a matrix of pairwise ARIs that show
how related each cluster solution is to each other can be generated by the
\code{calc_aris} function. Partitioning of the ARI matrix can be done by
visual inspection of \code{adjusted_rand_index_heatmap()} or by
\code{shiny_annotator}. Given the indices of meta cluster boundaries, this
function will return a single representative solution from each meta cluster
based on maximum average ARI to all other solutions within that meta
cluster.
}
