% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coclustering.R
\name{batch_snf_subsamples}
\alias{batch_snf_subsamples}
\title{Run SNF clustering pipeline on a list of subsampled data lists.}
\usage{
batch_snf_subsamples(
  data_list_subsamples,
  settings_matrix,
  processes = 1,
  return_similarity_matrices = FALSE,
  clust_algs_list = NULL,
  suppress_clustering = FALSE,
  distance_metrics_list = NULL,
  weights_matrix = NULL,
  automatic_standard_normalize = FALSE,
  return_solutions_matrices = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{data_list_subsamples}{A list of subsampled data lists. This object is
generated by the function \code{batch_snf_subsamples()}.}

\item{settings_matrix}{A settings matrix defining the parameters of the SNF
pipelines to be applied to the subsampled data lists.}

\item{processes}{See ?batch_snf.}

\item{return_similarity_matrices}{See ?batch_snf.}

\item{clust_algs_list}{See ?batch_snf.}

\item{suppress_clustering}{See ?batch_snf.}

\item{distance_metrics_list}{See ?batch_snf.}

\item{weights_matrix}{See ?batch_snf.}

\item{automatic_standard_normalize}{See ?batch_snf.}

\item{return_solutions_matrices}{If TRUE, includes the solutions matrices
corresponding to each subsample in the output.}

\item{verbose}{If TRUE, print time remaining estimates to console.}
}
\value{
By default, returns a one-element list: \code{cluster_solutions}, which
is itself a list of cluster solution data frames corresponding to each of
the provided data list subsamples. Setting the parameters
\code{return_similarity_matrices}  and \code{return_solutions_matrices} to \code{TRUE}
will turn the result of the function to a three-element list containing the
corresponding solutions matrices and final fused similarity matrices of
those cluster solutions, should you require these objects for your own
stability calculations.
}
\description{
Run SNF clustering pipeline on a list of subsampled data lists.
}
