% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alluvial_plot.R
\name{alluvial_cluster_plot}
\alias{alluvial_cluster_plot}
\title{Alluvial plot of patients across cluster counts and important features}
\usage{
alluvial_cluster_plot(
  cluster_sequence,
  similarity_matrix,
  data_list = NULL,
  data = NULL,
  key_outcome,
  key_label = key_outcome,
  extra_outcomes = NULL,
  title = NULL
)
}
\arguments{
\item{cluster_sequence}{A list of clustering algorithms (typically, the same
algorithm varied over different numbers of clusters).}

\item{similarity_matrix}{A similarity matrix.}

\item{data_list}{A nested list of input data from \code{generate_data_list()}.}

\item{data}{A dataframe that contains features to include in the plot.}

\item{key_outcome}{The name of the feature that determines how each patient
stream is coloured in the alluvial plot.}

\item{key_label}{Name of key outcome to be used for the plot legend.}

\item{extra_outcomes}{Names of additional features to add to the plot.}

\item{title}{Title of the plot.}
}
\value{
An alluvial plot (class "gg" and "ggplot") showing distribution of
a feature across varying number cluster solutions.
}
\description{
Alluvial plot of patients across cluster counts and important features
}
