% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.orbbound.R
\name{print.orbbound}
\alias{print.orbbound}
\title{Print method for objects of class orbbound}
\usage{
\method{print}{orbbound}(
  x,
  comb.fixed = x$x$comb.fixed,
  comb.random = x$x$comb.random,
  header = TRUE,
  backtransf = x$backtransf,
  digits = gs("digits"),
  digits.stat = gs("digits.stat"),
  digits.pval = max(gs("digits.pval"), 2),
  digits.tau2 = gs("digits.tau2"),
  scientific.pval = gs("scientific.pval"),
  big.mark = gs("big.mark"),
  ...
)
}
\arguments{
\item{x}{An object of class \code{orbbound}.}

\item{comb.fixed}{A logical indicating whether sensitivity analysis
for fixed effect model should be printed.}

\item{comb.random}{A logical indicating whether sensitivity
analysis for random effects model should be printed.}

\item{header}{A logical indicating whether information on
meta-analysis should be printed at top of printout.}

\item{backtransf}{A logical indicating whether printed results
should be back transformed. If \code{backtransf=TRUE}, results
for \code{sm="OR"} are printed as odds ratios rather than log
odds ratios and results for \code{sm="ZCOR"} are printed as
correlations rather than Fisher's z transformed correlations, for
example.}

\item{digits}{Minimal number of significant digits, see
\code{print.default}.}

\item{digits.stat}{Minimal number of significant digits for z- or
t-value, see \code{print.default}.}

\item{digits.pval}{Minimal number of significant digits for p-value
of overall treatment effect, see \code{print.default}.}

\item{digits.tau2}{Minimal number of significant digits for
between-study variance, see \code{print.default}.}

\item{scientific.pval}{A logical specifying whether p-values should
be printed in scientific notation, e.g., 1.2345e-01 instead of
0.12345.}

\item{big.mark}{A character used as thousands separator.}

\item{\dots}{Additional arguments}
}
\description{
Print method for objects of class \code{orbbound}.
}
\details{
For summary measures 'RR', 'OR', and 'HR' column labeled maxbias
contains the relative bias, e.g. a value of 1.10 means a maximum
overestimation by 10 percent. If \code{logscale=TRUE} for these
summary measures, maximum bias is instead printed as absolute bias.
}
\examples{
data(Fleiss1993bin, package = "meta")

m1 <- metabin(d.asp, n.asp, d.plac, n.plac, data = Fleiss1993bin, sm = "OR")

orb1 <- orbbound(m1, k.suspect = 1:5)
print(orb1, digits = 2)

# Print log odds ratios instead of odds ratios
#
print(orb1, digits = 2, backtransf = FALSE)

# Assuming that studies are missing on the left side
#
orb1.missleft <- orbbound(m1, k.suspect = 1:5, left = TRUE)
orb1.missleft

m2 <- metabin(d.asp, n.asp, d.plac, n.plac,
              data = Fleiss1993bin, sm = "OR", method = "Inverse")

orb2 <- orbbound(m2, k.suspect = 1:5)
print(orb2, digits = 2)

}
\seealso{
\code{\link{orbbound}}, \code{\link{forest.orbbound}}
}
\author{
Guido Schwarzer \email{sc@imbi.uni-freiburg.de}
}
\keyword{print}
