% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpower.R
\name{mpower}
\alias{mpower}
\title{Compute Power for Meta-analysis}
\usage{
mpower(
  effect_size,
  sample_size,
  k,
  es_type,
  test_type = "two-tailed",
  p = 0.05,
  sd = NULL,
  con_table = NULL
)
}
\arguments{
\item{effect_size}{Expected effect size magnitude}

\item{sample_size}{Expected number of participants (per group)}

\item{k}{Expected number of studies}

\item{es_type}{'Correlation', 'd', or 'OR'}

\item{test_type}{"two-tailed" or "one-tailed"}

\item{p}{Significance level (Type I error probability)}

\item{sd}{(Optional) Fixed-effects models only: Expected standard deviation among all effect sizes}

\item{con_table}{(Optional) For Odds Ratio. Expected 2x2 contingency table as a vector in the following format: c(a,b,c,d)

\tabular{lcc}{
 2x2 Table   \tab Group 1 \tab Group 2 \cr
 Present     \tab a       \tab b       \cr
 Not Present \tab c       \tab d       \cr
}}
}
\value{
Estimated Power
}
\description{
Computes statistical power for meta-analytic main effects, tests of homogeneity, and categorical moderator models under
both fixed- and random-effects models.
}
\examples{
mpower(effect_size = .5, sample_size = 10, k = 10, es_type = "d")

}
\references{
Borenstein, M., Hedges, L. V., Higgins, J. P. T. and Rothstein, H. R.(2009). Introduction to meta-analysis, Chichester, UK: Wiley.

Hedges, L., Pigott, T. (2004). The Power of Statistical Tests for Moderators in Meta-Analysis Psychological Methods  9(4), 426-445.
doi: https://dx.doi.org/10.1037/1082-989x.9.4.426

Pigott, T. (2012). Advances in Meta-Analysis.
doi: https://dx.doi.org/10.1007/978-1-4614-2278-5
}
