% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayes.parobs.R
\name{bayes.parobs}
\alias{bayes.parobs}
\title{Fit Bayesian Inference for Multivariate Meta-Regression With a Partially Observed Within-Study Sample Covariance Matrix}
\usage{
bayes.parobs(
  Outcome,
  SD,
  XCovariate,
  WCovariate,
  Treat,
  Trial,
  Npt,
  fmodel = 1,
  prior = list(),
  mcmc = list(),
  control = list(),
  init = list(),
  Treat_order = NULL,
  Trial_order = NULL,
  group = NULL,
  group_order = NULL,
  scale_x = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{Outcome}{the aggregate mean of the responses for each arm of every study.}

\item{SD}{the standard deviation of the responses for each arm of every study.}

\item{XCovariate}{the aggregate covariates for the fixed effects.}

\item{WCovariate}{the aggregate covariates for the random effects.}

\item{Treat}{the treatment identifiers. This is equivalent to the arm number of each study. The number of unique treatments must be equal across trials. The elements within will be coerced to consecutive integers.}

\item{Trial}{the trial identifiers. This is equivalent to the arm labels in each study. The elements within will be coerced to consecutive integers}

\item{Npt}{the number of observations/participants for a unique \verb{(t,k)}, or each arm of every trial.}

\item{fmodel}{the model number. The possible values for \code{fmodel} are 1 to 5, each indicating a different prior specification for \eqn{\Sigma_tk}. It will default to M1, \code{fmodel=1} if not specified at function call. See the following model descriptions. The objects enclosed in parentheses at the end of every bullet point are the hyperparameters associated with each model.
\itemize{
\item \code{fmodel=1} - \eqn{\Sigma_tk = diag(\sigma_{tk,11}^2,\ldots,\sigma_{tk,JJ}^2)} where \eqn{\sigma_{tk,jj}^2 \sim IG(a_0,b_0)} and \eqn{IG(a,b)} is \href{https://en.wikipedia.org/wiki/Inverse-gamma_distribution}{the inverse-gamma distribution}. This specification is useful if the user does not care about the correlation recovery. (\code{c0}, \code{dj0}, \code{a0}, \code{b0}, \code{Omega0})
\item \code{fmodel=2} - \eqn{\Sigma_tk=\Sigma} for every combination of \eqn{(t,k)}{`(t,k)`} and \eqn{\Sigma^{-1}\sim Wish_{s_0}(\Sigma_0)}{Sig^{-1} ~ Wish(s0, Sigma0)}. This specification assumes that the user has prior knowledge that the correlation structure does not change across the arms included. (\code{c0}, \code{dj0}, \code{s0}, \code{Omega0}, \code{Sigma0})
\item \code{fmodel=3} - \eqn{\Sigma_tk=\Sigma_t} and \eqn{\Sigma_t^{-1}\sim  Wish_{s_0}(\Sigma_0)}. This is a relaxed version of \code{fmodel=2}, allowing the correlation structure to differ across trials but forcing it to stay identical within a trial. (\code{c0}, \code{dj0}, \code{s0}, \code{Omega0}, \code{Sigma0})
\item \code{fmodel=4} - \eqn{\Sigma_tk=\delta_tk \rho \delta_tk} where \eqn{\delta_tk=diag(\Sigma_{tk,11}^{1/2},\ldots,\Sigma_{tk,JJ}^{1/2})}, and \eqn{\rho} is the correlation matrix. This specification allows the variances to vary across arms but requires that the correlations be the same. This is due to the lack of correlation information in the data, which would in turn lead to the nonidentifiability of the correlations if they were allowed to vary. However, this still is an ambitious model which permits maximal degrees of freedom in terms of variance and correlation estimation. (\code{c0}, \code{dj0}, \code{a0}, \code{b0}, \code{Omega0})
\item \code{fmodel=5} - The fifth model is hierarchical and thus may require more data than the others: \eqn{(\Sigma_tk^{-1}\mid \Sigma)\sim  Wish_{\nu_0}((\nu_0-J-1)^{-1}\Sigma^{-1})} and \eqn{\Sigma \sim  Wish_{d_0}(\Sigma_0)}. \eqn{\Sigma_tk} encodes the within-treatment-arm variation while \eqn{\Sigma} captures the between-treatment-arm variation. The hierarchical structure allows the "borrowing of strength" across treatment arms. (\code{c0}, \code{dj0}, \code{d0}, \code{nu0}, \code{Sigma0}, \code{Omega0})
}}

\item{prior}{(Optional) a list of hyperparameters. Despite \code{theta} in every model, each \code{fmodel}, along with the \code{group} argument, requires a different set of hyperparameters. See \code{fmodel} for the model specifications.}

\item{mcmc}{(Optional) a list for MCMC specification. \code{ndiscard} is the number of burn-in iterations. \code{nskip} configures the thinning of the MCMC. For instance, if \code{nskip=5}, \code{bayes.parobs} will save the posterior sample every 5 iterations. \code{nkeep} is the size of the posterior sample. The total number of iterations will be \code{ndiscard + nskip * nkeep}.}

\item{control}{(Optional) a list of tuning parameters for \href{https://en.wikipedia.org/wiki/Metropolis-Hastings_algorithm}{the Metropolis-Hastings algorithm}. \code{Rho}, \code{R}, and \code{delta} are sampled through either localized Metropolis algorithm or delayed rejection robust adaptive Metropolis algorithm. \verb{*_stepsize} with the asterisk replaced with one of the names above specifies the stepsize for determining the sample evaluation points in the localized Metropolis algorithm. \code{sample_Rho} can be set to \code{FALSE} to suppress the sampling of \code{Rho} for \code{fmodel=4}. When \code{sample_Rho} is \code{FALSE}, \eqn{\rho} will be fixed using the value given by the \code{init} argument, which defaults to \eqn{0.5 I+0.511'} where \eqn{1} is the vector of ones.}

\item{init}{(Optional) a list of initial values for the parameters to be sampled: \code{theta}, \code{gamR}, \code{Omega}, and \code{Rho}. The initial value for \code{Rho} will be effective only if \code{fmodel=4}.}

\item{Treat_order}{(Optional) a vector of unique treatments to be used for renumbering the \code{Treat} vector. The first element will be assigned treatment zero, potentially indicating placebo. If not provided, the numbering will default to an alphabetical/numerical order.}

\item{Trial_order}{(Optional) a vector of unique trials. The first element will be assigned zero. If not provided, the numbering will default to an alphabetical/numerical order.}

\item{group}{(Optional) a vector containing binary variables for \eqn{u_tk}. If not provided, \code{bayes.parobs} will assume that there is no grouping and set \eqn{u_tk=0} for all \verb{(t,k)}.}

\item{group_order}{(Optional) a vector of unique group labels. The first element will be assigned zero. If not provided, the numbering will default to an alphabetical/numerical order. \code{group_order} will take effect only if \code{group} is provided by the user.}

\item{scale_x}{(Optional) a logical variable indicating whether \code{XCovariate} should be scaled/standardized. The effect of setting this to \code{TRUE} is not limited to merely standardizing \code{XCovariate}. The following generic functions will scale the posterior sample of \code{theta} back to its original unit: \code{plot}, \code{fitted}, \code{summary}, and \code{print}.}

\item{verbose}{(Optional) a logical variable indicating whether to print the progress bar during the MCMC sampling.}
}
\value{
\code{bayes.parobs} returns an object of class \code{"bayes.parobs"}. The functions \code{summary} or \code{print} are used to obtain and print a summary of the results. The generic accessor function \code{fitted} extracts the posterior mean, posterior standard deviation, and the interval estimates of the value returned by \code{bayes.parobs}.

An object of class \code{bayes.nmr} is a list containing the following components:
\itemize{
\item \code{Outcome} - the aggregate response used in the function call.
\item \code{SD} - the standard deviation used in the function call.
\item \code{Npt} - the number of participants for \verb{(t,k)} used in the function call.
\item \code{XCovariate} - the aggregate design matrix for fixed effects used in the function call. Depending on \code{scale_x}, this may differ from #' the matrix provided at function call.
\item \code{WCovariate} - the aggregate design matrix for random effects.
\item \code{Treat} - the \emph{renumbered} treatment indicators. Depending on \code{Treat_order}, it may differ from the vector provided at function call.
\item \code{Trial} - the \emph{renumbered} trial indicators. Depending on \code{Trial_order}, it may differ from the vector provided at function call.
\item \code{group} - the \emph{renumbered} grouping indicators in the function call. Depending on \code{group_order}, it may differ from the vector provided at function call. If \code{group} was missing at function call, \code{bayes.parobs} will assign \code{NULL} for \code{group}.
\item \code{TrtLabels} - the vector of treatment labels corresponding to the renumbered \code{Treat}. This is equivalent to \code{Treat_order} if it was given at function call.
\item \code{TrialLabels} - the vector of trial labels corresponding to the renumbered \code{Trial}. This is equivalent to \code{Trial_order} if it was given at function call.
\item \code{GroupLabels} - the vector of group labels corresponding to the renumbered \code{group}. This is equivalent to \code{group_order} if it was given at function call. If \code{group} was missing at function call, \code{bayes.parobs} will assign \code{NULL} for \code{GroupLabels}.
\item \code{K} - the total number of trials.
\item \code{T} - the total number of treatments.
\item \code{fmodel} - the model number as described \href{#model-spec}{here}.
\item \code{scale_x} - a Boolean indicating whether \code{XCovariate} has been scaled/standardized.
\item \code{prior} - the list of hyperparameters used in the function call.
\item \code{control} - the list of tuning parameters used for MCMC in the function call.
\item \code{mcmctime} - the elapsed time for the MCMC algorithm in the function call. This does not include all the other preprocessing and post-processing outside of MCMC.
\item \code{mcmc} - the list of MCMC specification used in the function call.
\item \code{mcmc.draws} - the list containing the MCMC draws. The posterior sample will be accessible here.
}
}
\description{
This is a function for running the Markov chain Monte Carlo algorithm for the \emph{Bayesian inference for multivariate meta-regression with a partially observed within-study sample covariance matrix} model. The first six arguments are required.
fmodel can be one of 5 numbers: 1, 2, 3, 4, and 5. The first model, fmodel = 1 denoted by M1, indicates that the \eqn{\Sigma_tk}
are diagonal matrices with zero covariances. M2 indicates that \eqn{\Sigma_tk} are all equivalent but allowed to be full symmetric
positive definite. M3 is where \eqn{\Sigma_tk} are allowed to differ across treatments, i.e., \eqn{\Sigma_tk=\Sigma_t}.
M4 assumes thata the correlation matrix, \eqn{\rho}, is identical for all trials/treatments, but the variances are allowed to vary.
Finally, M5 assumes a hierarchical model where \eqn{(\Sigma_tk | \Sigma)} follows an inverse-Wishart distribution with fixed
degrees of freedom and scale matrix \eqn{\Sigma}. \eqn{\Sigma} then follows another inverse-Wishart distribution with fixed parameters.
}
\examples{
library(metapack)
data("cholesterol")
Outcome <- model.matrix(~ pldlc + phdlc + ptg, data = cholesterol)
SD <- model.matrix(~ sdldl + sdhdl + sdtg, data = cholesterol)
Trial <- cholesterol$Trial
Treat <- cholesterol$trt
Npt <- cholesterol$Npt
XCovariate <- model.matrix(~ 0 + bldlc + bhdlc + btg + age + durat +
 white + male + dm, data = cholesterol)
WCovariate <- model.matrix(~ trt, data = cholesterol)

fmodel <- 1
set.seed(2797542)
fit <- bayes.parobs(Outcome, SD, XCovariate, WCovariate, Treat, Trial,
   Npt, fmodel, mcmc = list(ndiscard = 1, nskip = 1, nkeep = 1),
   scale_x = TRUE, group = cholesterol$onstat, verbose = FALSE)
}
\references{
Yao, H., Kim, S., Chen, M. H., Ibrahim, J. G., Shah, A. K., & Lin, J. (2015). Bayesian inference for multivariate meta-regression with a partially observed within-study sample covariance matrix. \emph{Journal of the American Statistical Association}, \strong{110(510)}, 528-544.
}
\author{
Daeyoung Lim, \email{daeyoung.lim@uconn.edu}
}
