% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mahala_design.R
\name{mahala_design}
\alias{mahala_design}
\title{Mahalanobis distance from designed experiments}
\usage{
mahala_design(
  .data,
  gen,
  rep,
  resp,
  design = "RCBD",
  by = NULL,
  return = "distance"
)
}
\arguments{
\item{.data}{The dataset containing the columns related to Genotypes,
replication/block and response variables, possible with grouped data passed
from \code{\link[dplyr]{group_by}()}.}

\item{gen}{The name of the column that contains the levels of the genotypes.}

\item{rep}{The name of the column that contains the levels of the
replications/blocks.}

\item{resp}{The response variables. For example \code{resp = c(var1, var2,
var3)}.}

\item{design}{The experimental design. Must be RCBD or CRD.}

\item{by}{One variable (factor) to compute the function by. It is a shortcut
to \code{\link[dplyr]{group_by}()}. To compute the statistics by more than
one grouping variable use that function.}

\item{return}{What the function return? Default is 'distance', i.e., the
Mahalanobis distance. Alternatively, it is possible to return the matrix of
means \code{return = 'means'}, or the variance-covariance matrix of
residuals \code{return = 'covmat'}.}
}
\value{
A symmetric matrix with the Mahalanobis' distance. If \code{.data} is
  a grouped data passed from \code{\link[dplyr]{group_by}()} then the results
  will be returned into a list-column of data frames.
}
\description{
Compute the Mahalanobis distance using data from an experiment conducted in a
randomized complete block design or completely randomized design.
}
\examples{
\donttest{
library(metan)
maha <- mahala_design(data_g,
                      gen = GEN,
                      rep = REP,
                      resp = everything(),
                      return = "covmat")

# Compute one distance for each environment (all numeric variables)
maha_group <- mahala_design(data_ge,
                           gen = GEN,
                           rep = REP,
                           resp = everything(),
                           by = ENV)

# Return the variance-covariance matrix of residuals
cov_mat <- mahala_design(data_ge,
                        gen = GEN,
                        rep = REP,
                        resp = c(GY, HM),
                        return = 'covmat')
}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
