% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mgidi.R
\name{mgidi}
\alias{mgidi}
\title{Genotype-Ideotype Distance Index}
\usage{
mgidi(.data, SI = 15, mineval = 1, ideotype = NULL, verbose = TRUE)
}
\arguments{
\item{.data}{An object fitted with \code{\link{gamem}}, \code{\link{gamem_met}}, or a two-way
table with BLUPs for genotypes in each trait (genotypes in rows and traits
in columns). In the last case, row names must contain the genotypes names.}

\item{SI}{An integer (0-100). The selection intensity in percentage of the
total number of genotypes.}

\item{mineval}{The minimum value so that an eigenvector is retained in the
factor analysis.}

\item{ideotype}{A vector of length \code{nvar} where \code{nvar} is the
number of variables used to plan the ideotype. Use \code{'h'} to indicate
the variables with increase in selction or \code{'l'} to indicate the
variables with reduction in selection. For example, \code{ideotype = c("h,
  h, l, h, l")}.}

\item{verbose}{If \code{verbose = TRUE} (Default) then some results are
shown in the console.}
}
\value{
An object of class \code{mgidi} with the following items:
\itemize{
\item \strong{data} The data used to compute the factor analysis.
\item \strong{cormat} The correlation matrix among the environments.
\item \strong{PCA} The eigenvalues and explained variance.
\item \strong{FA} The factor analysis.
\item \strong{KMO} The result for the Kaiser-Meyer-Olkin test.
\item \strong{MSA} The measure of sampling adequacy for individual variable.
\item \strong{communalities} The communalities.
\item \strong{communalities.mean} The communalities' mean.
\item \strong{initial.loadings} The initial loadings.
\item \strong{finish.loadings} The final loadings after varimax rotation.
\item \strong{canonical.loadings} The canonical loadings.
\item \strong{scores.gen} The scores for genotypes in all retained factors.
\item \strong{scores.ide} The scores for the ideotype in all retained factors.
\item \strong{MGIDI} The multi-trait stability index.
\item \strong{contri.fac} The relative contribution of each factor on the MGIDI value.
The lower the contribution of a factor, the close of the ideotype the variables in such
factor are.
\item \strong{sel.dif} The selection differential for the variables.
\item \strong{Selected} The selected genotypes.
}
}
\description{
Computes the multi-trait genotype-ideotype distance index (MGIDI). MGIDI can
be seen as the multi-trait stability index (Olivoto et al., 2019) computed
with weight for mean performance equals to 100.
}
\examples{
\donttest{
library(metan)

model <- gamem(data_g,
               gen = GEN,
               rep = REP,
               resp = c(NR, KW, CW, CL, NKE, TKW, PERK, PH))
# Selection for increase all variables
mgidi_model <- mgidi(model)

}
}
\references{
Olivoto, T., A.D.C. L{\'{u}}cio, J.A.G. da silva, B.G. Sari, and
M.I. Diel. 2019. Mean performance and stability in multi-environment trials
II: Selection based on multiple traits. Agron. J. 111:2961-2969.
\href{https://acsess.onlinelibrary.wiley.com/doi/full/10.2134/agronj2019.03.0221}{doi:10.2134/agronj2019.03.0220}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
