% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imputation.r
\name{impute_conditional_mean}
\alias{impute_conditional_mean}
\title{Impute missing values by their conditional mean}
\usage{
impute_conditional_mean(x, mu, Sigma)
}
\arguments{
\item{x}{A vector with observations, some of which may be missing (indicated by NA)}

\item{mu}{A vector with the population means for 'x'. No missing values are allowed here.}

\item{Sigma}{A matrix describing the population covariance of 'x'}
}
\value{
A vector where missing values for 'x' have been replaced by their conditional mean
}
\description{
This function imputes missing values by their conditional mean
}
\examples{
# Define the population means
mu <- c(0, 1, 2)

# Define the covariance of the population
Sigma <- diag(1,3)
Sigma[1,2] <- Sigma[2,1] <- 0.3 
Sigma[2,3] <- Sigma[3,2] <- 0.1
Sigma[1,3] <- Sigma[3,1] <- -0.2

# Generate a 'random' sample from the population that is partially observed
x <- c(NA, 2, 4)

# Impute the missing values
impute_conditional_mean (x=x, mu=mu, Sigma=Sigma)

}
\author{
Thomas Debray <thomas.debray@gmail.com>
}
\keyword{imputation}
