% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define.R
\name{define_analysis}
\alias{define_analysis}
\title{Define analysis function meta information for ADaM dataset}
\usage{
define_analysis(meta, name, ...)
}
\arguments{
\item{meta}{A \code{meta_adam} object.}

\item{name}{A character value of term name.
The term name is used as key to link information.}

\item{...}{Additional variables.}
}
\value{
A metadata object with analysis details defined.
}
\description{
Define analysis function meta information for ADaM dataset
}
\examples{
plan <- plan(
  analysis = "ae_summary", population = "apat",
  observation = c("wk12", "wk24"), parameter = "any;rel;ser"
)

meta_adam(
  population = r2rtf::r2rtf_adsl,
  observation = r2rtf::r2rtf_adae
) |>
  define_plan(plan = plan) |>
  define_analysis(
    name = "ae_summary",
    title = "Summary of Adverse Events"
  )
}
