% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaheuristic.mainFunction.R
\name{metaOpt}
\alias{metaOpt}
\title{metaOpt The main function to execute algorithms for getting optimal solutions}
\usage{
metaOpt(FUN, optimType = "MIN", algorithm = "PSO", numVar, rangeVar,
  control = list(), seed = NULL)
}
\arguments{
\item{FUN}{an objective function or cost function,}

\item{optimType}{a string value that represents the type of optimization.
There are two options for this arguments: \code{"MIN"} and \code{"MAX"}.
The default value is \code{"MIN"}, referring the minimization problem. 
Otherwise, you can use \code{"MAX"} for maximization problem.}

\item{algorithm}{a vector or single string value that represent the algorithm used to 
       do optimization. There are currently eleven implemented algorithm:
\itemize{
\item \code{"PSO"}: Particle Swarm Optimization. See \code{\link{PSO}};
\item \code{"ALO"}: Ant Lion Optimizer. See \code{\link{ALO}};
\item \code{"GWO"}: Grey Wolf Optimizer. See \code{\link{GWO}}
\item \code{"DA"} : Dragonfly Algorithm. See \code{\link{DA}}
\item \code{"FFA"}: Firefly Algorithm. See \code{\link{FFA}}
\item \code{"GA"} : Genetic Algorithm. See \code{\link{GA}}
\item \code{"GOA"}: Grasshopper Optimisation Algorithm. See \code{\link{GOA}}
\item \code{"HS"}: Harmony Search Algorithm. See \code{\link{HS}}
\item \code{"MFO"}: Moth Flame Optimizer. See \code{\link{MFO}}
\item \code{"SCA"}: Sine Cosine Algorithm. See \code{\link{SCA}}
\item \code{"WOA"}: Whale Optimization Algorithm. See \code{\link{WOA}}
}}

\item{numVar}{a positive integer to determine the number variables.}

\item{rangeVar}{a matrix (\eqn{2 \times n}) containing the range of variables, 
where \eqn{n} is the number of variables, and first and second rows
are the lower bound (minimum) and upper bound (maximum) values, respectively. 
If all variable have equal upper bound, you can define \code{rangeVar} as 
matrix (\eqn{2 \times 1}).}

\item{control}{a list containing all arguments, depending on the algorithm to use. The following list are 
       parameters required for each algorithm.
\itemize{
\item \code{PSO}: 

    \code{list(numPopulation, maxIter, Vmax, ci, cg, w)}

\item \code{ALO}: 

    \code{list(numPopulation, maxIter)}

\item \code{GWO}: 

    \code{list(numPopulation, maxIter)}

\item \code{DA}: 

    \code{list(numPopulation, maxIter)}

\item \code{FFA}: 

    \code{list(numPopulation, maxIter, B0, gamma, alpha)}

\item \code{GA}: 

    \code{list(numPopulation, maxIter, Pm, Pc)}

\item \code{GOA}: 

    \code{list(numPopulation, maxIter)}

\item \code{HS}: 

    \code{list(numPopulation, maxIter, PAR, HMCR, bandwith)}

\item \code{MFO}: 

    \code{list(numPopulation, maxIter)}

\item \code{SCA}: 

    \code{list(numPopulation, maxIter)}

\item \code{WOA}: 

    \code{list(numPopulation, maxIter)}

\bold{Description of the \code{control} Parameters}
\itemize{
\item \code{numPopulation}: a positive integer to determine the number population. 
      The default value is 40.

\item \code{maxIter}: a positive integer to determine the maximum number of iteration. 
      The default value is 500.

\item \code{Vmax}: a positive integer to determine the maximum velocity of particle. 
      The default value is 2.

\item \code{ci}: a positive integer to determine the individual cognitive. 
      The default value is 1.49445.

\item \code{cg}: a positive integer to determine the group cognitive. 
      The default value is 1.49445.

\item \code{w}: a positive integer to determine the inertia weight. 
      The default value is 0.729.

\item \code{B0}: a positive integer to determine the attractiveness firefly at r=0. 
      The default value is 1.

\item \code{gamma}: a positive integer to determine light absorption coefficient. 
      The default value is 1.

\item \code{alpha}: a positive integer to determine randomization parameter. 
      The default value is 0.2.

\item \code{Pm}: a positive integer to determine mutation probability. 
      The default value is 0.1.

\item \code{Pc}: a positive integer to determine crossover probability. 
      The default value is 0.8.

\item \code{PAR}: a positive integer to determine Pinch Adjusting Rate. 
      The default value is 0.3.

\item \code{HMCR}: a positive integer to determine Harmony Memory Considering Rate. 
      The default value is 0.95.

\item \code{bandwith}: a positive integer to determine distance bandwith. 
      The default value is 0.05.
}
}}

\item{seed}{a number to determine the seed for RNG.}
}
\value{
\code{List} that contain list of variable, optimum value and execution time.
}
\description{
A main funtion to compute the optimal solution using a selected algorithm.
}
\details{
This function makes accessible all algorithm that are implemented 
in this package. All of the algorithm use this function as interface to find 
the optimal solution, so users do not need to call other functions.
In order to obtain good results, users need to adjust some parameters such as the 
objective function, optimum type, number variable or dimension, number populations, 
the maximal number of iterations, lower bound, upper bound, or other algorithm-dependent parameters 
which are collected in the control parameter.
}
\examples{
################################## 
## Optimizing the sphere function

## Define sphere function as an objective function 
sphere <- function(X){
    return(sum(X^2))
}

## Define control variable 
control <- list(numPopulation=40, maxIter=100, Vmax=2, ci=1.49445, cg=1.49445, w=0.729)

numVar <- 5
rangeVar <- matrix(c(-10,10), nrow=2)

## Define control variable 
best.variable <- metaOpt(sphere, optimType="MIN", algorithm="PSO", numVar, 
                         rangeVar, control)

}
