% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/replicate_MetaWin2.0.R
\name{replicate_MetaWin2.0}
\alias{replicate_MetaWin2.0}
\title{Replicate meta-analysis results and summaries from MetaWin 2.0.}
\usage{
replicate_MetaWin2.0(model, weights, effects_model = "random", data,
  bootstraps = 999)
}
\arguments{
\item{model}{A two-sided linear formula object describing the model, with the
response (effect sizes) on the left of a ~ operator and the moderator
variables, separated by +, :, * operators, on the right.  NOTE:
MetaWin was limited to analyses with a single moderator variable.
This function currently supports only categorical moderators.}

\item{weights}{A vector of effect size variances that will be used as
weights for the meta-analysis.}

\item{effects_model}{The default is \code{"random"}, which specifies a
random-effects meta-analysis.  Other options include \code{"fixed"}
which presents fixed-effect analyses.}

\item{data}{An optional data frame containing the variables named in model
and weights.}

\item{bootstraps}{The number of bootstraps used to estimate confidence
   intervals.  As with 'MetaWin' 2.0, the default is 999.}
}
\description{
Replicate meta-analysis results and summaries from Rosenberg's et al. (2000)
software 'MetaWin' 2.0.  Currently only replicates moderator analyses and not
meta-regressions.
}
\references{
Rosenberg, M.S., Adams, D.C., and Gurevitch, J. 2000.
   MetaWin: Statistical Software for Meta-Analysis. Sinauer Associates
   Sunderland, Massachusetts.
}

