% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readingandfes.R
\name{fes.hillsfile3d}
\alias{fes.hillsfile3d}
\title{Calculate 3D free energy surface by Bias Sum algorithm}
\usage{
\method{fes}{hillsfile3d}(hills, imin = 1, imax = NULL, xlim = NULL,
  ylim = NULL, zlim = NULL, npoints = NULL)
}
\arguments{
\item{hills}{hillsfile3d object.}

\item{imin}{index of a hill from which summation starts (default 1).}

\item{imax}{index of a hill from which summation stops (default the rest of hills).}
  
\item{xlim}{numeric vector of length 1, giving the CV2 coordinates range.}

\item{ylim}{numeric vector of length 2, giving the CV2 coordinates range.}

\item{zlim}{numeric vector of length 2, giving the CV3 coordinates range.}

\item{npoints}{resolution of the free energy surface in number of points.}
}
\value{
fes object.
}
\description{
`fes.hillsfile3d` sums up hills using fast Bias Sum algorithm.
}
\examples{
tfes<-fes(acealanme3d, imax=5000)
}
