% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metacart-package.R
\docType{package}
\name{metacart-package}
\alias{metacart-package}
\title{R package for meta-CART}
\description{
In many areas, there are multiple moderators available (e.g., intervention characteristics).
In such cases, traditional meta-analysis methods often lack sufficient power to investigate
interaction effects between moderators, especially high-order interactions.
To solve this problem, meta-CART was proposed by integrating Classification and Regression Trees (CART)
into meta-analysis. The method idenfities the interaction effects between influential moderators,
splits the studies into more homogeneous subgroups, and test the interaction effects by Q-statistic.
The fixed effect or random effects assumption can be consistently taken into account in both detection and testing process.
}
\details{
\tabular{ll}{
  Package: \tab metacart\cr
  Type: \tab Package\cr
  Version: \tab 1.0-0\cr
  Date: \tab 2017-10-02\cr
  License: \tab GPL\cr
}

  This method is suitable for identifying interaction effects between dichotomous,
  ordinal, continuous, and nominal moderators.
  The output of a \code{REmrt} object shows meta-CART analysis results based on the random effects model.
  And the output of a \code{FEmrt} object shows meta-CART analysis results based on the fixed effect model.
  The two objects display results for subgroup analysis including the Q-statistic and estimates for the subgroup effect sizes.
  Furthermore the predict functions \code{predict.REmrt} and \code{predict.FEmrt} can be used to predict the effect size given the moderators.
  The plot functions \code{plot.REmrt} and \code{plot.FEmrt} show the interaction effects between identified moderators.

  The core functions of the package are \code{\link{FEmrt}} and  \code{\link{REmrt}}..
}
\references{
Dusseldorp, E., van Genugten, L., van Buuren, S., Verheijden, M. W., & van Empelen, P. (2014). Combinations of techniques that effectively change health behavior: Evidence from meta-cart analysis.  \emph{Health Psychology, 33 (12)}, 1530-1540. doi:
     10.1037/hea0000018.

Li, X., Dusseldorp, E., & Meulman, J. J. (2017). Meta-CART: A tool to identify interactions between moderators in meta-analysis. \emph{British Journal of Mathematical and Statistical Psychology, 70(1)}, 118-136. doi: 10.1111/bmsp.12088.

Therneau, T., Atkinson, B., & Ripley, B. (2014) rpart: Recursive partitioning and regression trees. R package version, 4-1.

The articles of our own work can be found at \url{http://www.elisedusseldorp.nl/}
}
\seealso{
\code{\link{FEmrt}}, \code{\link{REmrt}}, \code{\link{summary.FEmrt}},\code{\link{summary.REmrt}},
  \code{\link{plot.FEmrt}},\code{\link{plot.REmrt}},\code{\link{predict.FEmrt}},\code{\link{predict.REmrt}}
}
\author{
Maintainer: Xinru Li <x.li@math.leidenuniv.nl>; Contributors: Elise Dusseldorp, Kaihua Liu (supported with the plot function), Jacqueline Meulman.
}
\keyword{package}
