% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{create_Metabolite}
\alias{create_Metabolite}
\title{Create a Metabolite object}
\usage{
create_Metabolite(
  assayData,
  featureData,
  sampleData,
  featureID,
  sampleID,
  logs
)
}
\arguments{
\item{assayData}{a data.frame or data.table of metabolite measurements (peak area data or normalized data, sample [row] * feature [column]).}

\item{featureData}{a data.frame or data.table of metabolite annotation (chemical annotation)}

\item{sampleData}{a data.frame or data.table of sample annotation (sample meta data).}

\item{featureID}{a character of the metabolite ID column (in feature file and the column names of data), default: CHEM_ID (provided from Metabolon file).}

\item{sampleID}{a character of the sample ID column (in sample and the first column of data), default: PARENT_SAMPLE_NAME (provided from Metabolon file).}

\item{logs}{Log information.}
}
\value{
A Metabolite object with slots: assayData, featureData, and sampleData.

A Metabolite object.
}
\description{
Create a Metabolite object from three input data sets:
1) metabolite measurements (eg. peak area data or normalized data), and
2) metabolite annotation (eg. chemical annotation)
3) sample annotation (eg. sample meta data)
}
\examples{
# df <- create_Metabolite(assayData = df_data, featureData = df_feature, sampleData =  df_sample)
}
\seealso{
\code{\link{Metabolite}}, \code{\link{load_excel}}, \code{\link{load_data}}
}
