% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{QC_pipeline}
\alias{QC_pipeline}
\title{quality control pipeline}
\usage{
QC_pipeline(
  object,
  filter_column_constant = TRUE,
  filter_column_missing_rate_threshold = 0.5,
  filter_row_missing_rate_threshold = NULL,
  replace_outlier_method = NULL,
  nSD = 5,
  impute_method = "half-min",
  verbose = TRUE
)
}
\arguments{
\item{object}{An object, data.frame, data.table or Metabolite.}

\item{filter_column_constant}{A logical value, whether to filter columns (features) with a constant value.}

\item{filter_column_missing_rate_threshold}{A numeric threshold to filter columns (features) below a missing rate, default: 0.5. Other values: 0.2, 0.8. If NULL, then skip this step.}

\item{filter_row_missing_rate_threshold}{A numeric threshold to filter rows (samples) below a missing rate. Default: NULL, to skip this step. Other values: 0.5, 0.2, 0.8.}

\item{replace_outlier_method}{Method to replace outlier value, see \code{\link{replace_outlier}}.}

\item{nSD}{Define the N times of the SD as outliers.}

\item{impute_method}{Imputation method, the default method is half the minimum value (`half-min`) of the metabolite. Currently support 'half-min', "median", "mean", "zero".}

\item{verbose}{print log information.}
}
\value{
A Metabolite object after QC.
}
\description{
This function will run QC steps on a Metabolite object
}
