% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_roc.r
\name{predict_roc.metaSDTdata}
\alias{predict_roc.metaSDTdata}
\title{Observed ROC points}
\usage{
\method{predict_roc}{metaSDTdata}(object, type = c("1", "n", "s"), s0 = 0, s1 = 1, ...)
}
\arguments{
\item{object}{A 'metaSDTdata' object from which to calculate observed ROC points.}

\item{type}{The type of ROC curve to predict. A character string, where '1' requests the type 1 ROC curve, 'n' requests the type 2 noise-specific and 's' the type 2 signal-specific ROC curve.}

\item{s0}{Numeric, the value of object$signal to regard as 'noise'. Defaults to 0.}

\item{s1}{Numeric, the value of object$signal to regard as 'signal'. Defaults to 1.}

\item{...}{For future methods}
}
\value{
A matrix two-column matrix of class 'predict_roc' with one row of c(FA, HR) per threshold (FA: False Alarm rate, HR: Hit Rate).
}
\description{
The observed points of the ROC curve from a 'metaSDTdata' object.
}
\details{
Note that the type 1 ROC points arise by using each criterion in turn to decide between 'signal' and 'noise'. Since this involves also the type 2 thresholds, such a curve is also sometimes referred to as a 'pseudo' ROC curve.
}
\examples{
## Declare simulated data as metaSDTdata
metadata <- metaSDTdata(simMetaData, type1='resp', type2='conf', signal='S')

## Observed signal-specific ROC curve
signalROC <- predict_roc(metadata, type = 's')

}
\references{
Maniscalco, B., & Lau, H. (2014).
Signal Detection Theory Analysis of Type 1 and Type 2 Data: Meta-d , Response-Specific Meta-d , and the Unequal Variance SDT Model.
In S. M. Fleming, & C. D. Frith (Eds.), The {Cognitive} {Neuroscience} of {Metacognition}
(pp. 25 66). : Springer Berlin Heidelberg.
}
