% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{metabolic_scaling}
\alias{metabolic_scaling}
\title{Metabolic scaling}
\usage{
metabolic_scaling(
  normalization_constant,
  scaling_exponent,
  mass,
  temperature,
  E,
  k = 8.617333e-05
)
}
\arguments{
\item{normalization_constant}{\verb{<numeric>} normalization constant.}

\item{scaling_exponent}{\verb{<numeric>} allometric scaling exponent of the mass.}

\item{mass}{\verb{<numeric matrix>}  mean (individual) mass.}

\item{temperature}{\verb{<numeric matrix>} temperature in kelvin (K).}

\item{E}{\verb{<numeric>} activation energy in electronvolts (eV).}

\item{k}{\verb{<numeric>} Boltzmann's constant (eV / K).}
}
\value{
\verb{<numeric>} The scaled parameter.
}
\description{
A function to calculate the metabolic scaling of a parameter, based on the
metabolic theory of ecology (Brown et al. 2004).
}
\details{
\subsection{Equation:}{

The function uses the equation in the form of:
\deqn{parameter = normalization\_constant \cdot mass^{scaling\_exponent} \cdot e^{\frac{Activation\_energy}{k \cdot temperature}}}{parameter = normalization_constant * mass^scaling_exponent * e^(Activation_energy/ (k * temperature))}
}

\subsection{Parameter:}{

Note the different scaling values for different parameter.
The following is a summary from table 4 in Brown, Sibly and Kodric-Brown (2012)
(see references).\tabular{lcr}{
   Parameter \tab Scaling exponent \tab Activation energy \cr
   resource usage \tab 3/4 \tab -0.65 \cr
   reproduction, mortality \tab -1/4 \tab -0.65 \cr
   carrying capacity \tab -3/4 \tab 0.65 \cr
}

}

\subsection{Units:}{

\deqn{1 \ electronvolt = 1.602176634 \cdot 10^{-19} Joule}{1 electronvolt = 1.602176634 * 10^-19 Joule}

\deqn{Boltzmann \ constant = 1.380649 \cdot 10^{-23} \frac{Joule}{Kelvin}}{Boltzmann constant = 1.380649 * 10^-23 Joule/Kelvin}

\deqn{Boltzmann \ constant \ in \frac{eV}{K} = 8.617333e-05 = \frac{1.380649 \cdot 10^{-23}}{1.602176634 \cdot 10^{-19}}}{Boltzmann constant in eV/K = 8.617333e-05 = (1.380649 * 10^-23) / (1.602176634 * 10^-19)}
}
}
\examples{
reproduction_rate <- 0.25
E_reproduction_rate <- -0.65
estimated_normalization_constant <-
    calculate_normalization_constant(
        parameter_value = reproduction_rate,
        scaling_exponent = -1/4,
        mass = 100,
        reference_temperature = 273.15 + 10,
        E = E_reproduction_rate
    )
metabolic_scaling(
    normalization_constant = estimated_normalization_constant,
    scaling_exponent = -1/4,
    mass = 100,
    temperature = 273.15 + 20,
    E = E_reproduction_rate
)

carrying_capacity <- 100
E_carrying_capacity <- 0.65
estimated_normalization_constant <-
    calculate_normalization_constant(
        parameter_value = carrying_capacity,
        scaling_exponent = -3/4,
        mass = 100,
        reference_temperature = 273.15 + 10,
        E = E_carrying_capacity
    )
metabolic_scaling(
    normalization_constant = estimated_normalization_constant,
    scaling_exponent = -3/4,
    mass = 100,
    temperature = 273.15 + 20,
    E = E_carrying_capacity
)
}
\references{
Brown, J.H., Gillooly, J.F., Allen, A.P., Savage, V.M. and West, G.B. (2004)
Toward a Metabolic Theory of Ecology. \emph{Ecology}, \strong{85} 1771--1789.
\doi{10.1890/03-9000}

Brown, J.H., Sibly, R.M. and Kodric-Brown, A. (2012)
Introduction: Metabolism as the Basis for a Theoretical Unification of Ecology.
In \emph{Metabolic Ecology} (eds R.M. Sibly, J.H. Brown and A. Kodric-Brown)
\doi{10.1002/9781119968535.ch}
}
\seealso{
\code{calculate_normalization_constant()}
}
