% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaGEplot.R
\name{metaGE.regplot}
\alias{metaGE.regplot}
\title{Plot the z-score of a marker according to a covariate.}
\usage{
metaGE.regplot(
  Data,
  Covariate,
  EnvName,
  MarkerName,
  VarName,
  Zscore = FALSE,
  aesCol = NULL,
  Main = ""
)
}
\arguments{
\item{Data}{A dataset containing the columns: MARKER and the z-scores or the effects of each marker (in rows) in each environment (in columns), as obtained from \code{\link[=metaGE.collect]{metaGE.collect()}}.}

\item{Covariate}{A dataset containing the values of one or more covariates (in columns) in each environment (in rows).}

\item{EnvName}{The name of the column containing the names of the environment in the \code{Covariate} dataset.}

\item{MarkerName}{The name of the marker.}

\item{VarName}{The name of the column containing the covariable to plot.}

\item{Zscore}{A boolean. If \code{FALSE}, the estimated marker effects is plotted. If \code{TRUE}, the z-scores of the marker is plotted. (\code{FALSE} by default)}

\item{aesCol}{The name of the column in the \code{Covariate} dataset containing a qualitative covariable to specify the color of the points. (optional)}

\item{Main}{The main to display.(optional)}
}
\value{
The plot
}
\description{
The function metaGE.regplot displays the graph of the z-scores of a marker according to a covariate.
}
\examples{
data("metaData")
data("envDesc")
metaGE.regplot(Data = metaData, Covariate = envDesc, EnvName = "ShortName",
               MarkerName = "AX-91369217", VarName = "Tnight.mean", aesCol = "Classification")

}
