% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_bma.R
\name{meta_bma}
\alias{meta_bma}
\title{Model Averaging for Meta-Analysis}
\usage{
meta_bma(y, SE, labels, data, d = prior("norm", c(mean = 0, sd = 0.3)),
  tau = prior("invgamma", c(shape = 1, scale = 0.15)),
  rscale_contin = 1/2, rscale_discrete = sqrt(2)/2, centering = TRUE,
  prior = c(1, 1, 1, 1), logml = "integrate", summarize = "stan",
  ci = 0.95, rel.tol = .Machine$double.eps^0.3, logml_iter = 5000,
  silent_stan = TRUE, ...)
}
\arguments{
\item{y}{effect size per study. Can be provided as (1) a numeric vector, (2)
the quoted or unquoted name of the variable in \code{data}, or (3) a
\code{\link[stats]{formula}} to include discrete or continuous moderator
variables.}

\item{SE}{standard error of effect size for each study. Can be a numeric
vector or the quoted or unquoted name of the variable in \code{data}}

\item{labels}{optional: character values with study labels. Can be a
character vector or the quoted or unquoted name of the variable in
\code{data}}

\item{data}{data frame containing the variables for effect size \code{y},
standard error \code{SE}, \code{labels}, and moderators per study.}

\item{d}{\code{prior} distribution on the average effect size \eqn{d}. The
prior probability density function is defined via \code{\link{prior}}.}

\item{tau}{\code{prior} distribution on the between-study heterogeneity
\eqn{\tau} (i.e., the standard deviation of the study effect sizes
\code{dstudy} in a random-effects meta-analysis. A (nonnegative) prior
probability density function is defined via \code{\link{prior}}.}

\item{rscale_contin}{scale parameter of the JZS prior for the continuous
covariates.}

\item{rscale_discrete}{scale parameter of the JZS prior for discrete
moderators.}

\item{centering}{whether continuous moderators are centered.}

\item{prior}{prior probabilities over models (possibly unnormalized) in the
order \code{c(fixed_H0, fixed_H1, random_H0, random_H1)}. For instance, if
we expect fixed effects to be two times as likely as random effects and H0
and H1 to be equally likely: \code{prior = c(2,2,1,1)}.}

\item{logml}{how to estimate the log-marginal likelihood: either by numerical
integration (\code{"integrate"}) or by bridge sampling using MCMC/Stan
samples (\code{"stan"}). To obtain high precision with \code{logml="stan"},
many MCMC samples are required (e.g., \code{iter=10000, warmup=1000}).}

\item{summarize}{how to estimate parameter summaries (mean, median, SD,
etc.): Either by numerical integration (\code{summarize = "integrate"}) or
based on MCMC/Stan samples (\code{summarize = "stan"}).}

\item{ci}{probability for the credibility/highest-density intervals.}

\item{rel.tol}{relative tolerance used for numerical integration using
\code{\link[stats]{integrate}}. Use \code{rel.tol=.Machine$double.eps} for
maximal precision (however, this might be slow).}

\item{logml_iter}{number of iterations from the posterior of d and tau
for computing the marginal likelihood for the random-effects model with bridge sampling.
Note that the argument \code{iter=2000} controls the number of iterations
for parameter estimation of the random effects.}

\item{silent_stan}{whether to suppress the Stan progress bar.}

\item{...}{further arguments passed to \code{rstan::sampling} (see
\code{\link[rstan]{stanmodel-method-sampling}}). For instance:
\code{warmup=500}, \code{chains=4}, \code{control=list(adapt_delta=.95)}).}
}
\description{
Fits random- and fixed-effects meta-anayses and performs Bayesian model
averaging for H1 (d != 0) vs. H0 (d = 0).
}
\details{
Bayesian model averaging for four meta-analysis models: Fixed- vs.
random-effects and H0 (\eqn{d=0}) vs. H1 (e.g., \eqn{d>0}).

By default, the log-marginal likelihood is computed by numerical
integration. This is relatively fast and gives precise, reproducible results.
However, for extreme priors or data, this might be robust. Hence, as an
alternative, the log-marginal likelihood can be estimated using MCMC/Stan
samples and bridge sampling.

Note that the same two options are available to obtain summary statistics of
the posterior distributions of the average effect size \eqn{d} and the
heterogeneity parameter \eqn{tau}.
}
\examples{
# Note: The following example optimizes speed (for CRAN checks).
#       The settings are not suitable for actual data analysis!

data(towels)
set.seed(123)
mb <- meta_bma(logOR, SE, study, towels,
               d = prior("norm", c(mean=0, sd=.3), lower=0),
               tau = prior("invgamma", c(shape = 1, scale = 0.15)),
               rel.tol = .Machine$double.eps^.15, iter=1000)
mb
plot_posterior(mb, "d")
}
\references{
Gronau, Q. F., Erp, S. V., Heck, D. W., Cesario, J., Jonas, K. J., & Wagenmakers, E.-J. (2017). A Bayesian model-averaged meta-analysis of the power pose effect with informed and default priors: the case of felt power. Comprehensive Results in Social Psychology, 2(1), 123-138. \url{https://doi.org/10.1080/23743603.2017.1326760}
}
\seealso{
\link{meta_fixed}, \link{meta_random}
}
