% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_bma.R
\name{meta_bma}
\alias{meta_bma}
\title{Model Averaging for Meta-Analysis}
\usage{
meta_bma(y, SE, labels = NULL, d = "norm", d.par = c(0, 0.3),
  tau = "halfcauchy", tau.par = 0.5, prior = c(1, 1, 1, 1),
  sample = 10000, summarize = "integrate", ...)
}
\arguments{
\item{y}{mean in each study}

\item{SE}{standard error in each study}

\item{labels}{optional: character values with study labels}

\item{d}{type of prior for mean effect \eqn{d} (see \code{\link{prior}})}

\item{d.par}{prior parameters for \eqn{d}}

\item{tau}{type of prior for standard deviation of study effects \eqn{\tau} in random-effects meta-analysis (i.e., the SD of d across studies; see \code{\link{prior}})}

\item{tau.par}{prior parameters for \eqn{\tau}}

\item{prior}{prior probabilities over models (possibly unnormalized) in the order \code{c(fixed.H0, fixed.H1, random.H0, random.H1)}. For instance, if we expect fixed effects to be two times as likely as random effects and H0 and H1 to be equally likely: \code{prior = c(2,2,1,1)}}

\item{sample}{number of samples in JAGS after burn-in and thinning (see \code{\link[runjags]{run.jags}}). Samples are used to get posterior  estimates for each study effect (which will show shrinkage). Only works for priors defined in \code{\link{prior}}.}

\item{summarize}{whether and to compute parameter summaries (mean, median, SD, 95\% quantile interval, HPD interval). If \code{summarize = "integrate"}, numerical integration is used  (which is precise but can require some seconds of computing time), \code{summarize = "jags"} summarizes the JAGS samples, and \code{summarize = "none"} suppresses parameter summaries.}

\item{...}{arguments passed to \link[runjags]{run.jags} (e.g., MCMC parameters such as \code{sample}, \code{burnin}, \code{n.chains}, \code{thin} or \code{method="parallel"})}
}
\description{
Fits random- and fixed-effects meta-anayses and performs Bayesian model averaging for H1 (d != 0) vs. H0 (d = 0).
}
\details{
Bayesian model averaging for four meta-analysis models: Fixed- vs. random-effects and H0 (\eqn{d=0}) vs. H1 (e.g., \eqn{d>0}).
}
\examples{
\dontrun{
data(towels)
mb <- meta_bma(towels$logOR, towels$SE, towels$study,
               d = "norm", d.par = c(0,.3), sample = 10000,
               tau = "halfcauchy", tau.par = .5)
mb
plot_posterior(mb, "d")
plot_forest(mb)
}
}
\seealso{
\link{meta_default}, \link{meta_fixed}, \link{meta_random}
}
